/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common;

import com.burnedkirby.TurnBasedMinecraft.common.EntityInfo;
import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.world.damagesource.DamageType;
import org.apache.logging.log4j.Logger;

public class Config {
    public static final long BATTLE_DECISION_DURATION_SEC_MIN = 5L;
    public static final long BATTLE_DECISION_DURATION_SEC_MAX = 60L;
    public static final long BATTLE_DECISION_DURATION_SEC_DEFAULT = 15L;
    public static final long BATTLE_DECISION_DURATION_NANO_MIN = 5000000000L;
    public static final long BATTLE_DECISION_DURATION_NANO_MAX = 60000000000L;
    public static final long BATTLE_DECISION_DURATION_NANO_DEFAULT = 15000000000L;
    private long battleDecisionDurationNanos = 15000000000L;
    private boolean battleDecisionDurationForever = false;
    private Map<String, EntityInfo> entityInfoMap = new HashMap<String, EntityInfo>();
    private Map<String, EntityInfo> customEntityInfoMap = new HashMap<String, EntityInfo>();
    private Map<String, EntityInfo> customPlayerInfoMap = new HashMap<String, EntityInfo>();
    private Set<String> ignoreBattleTypes = new HashSet<String>();
    private Logger logger;
    private int playerSpeed = 50;
    private int playerHasteSpeed = 80;
    private int playerSlowSpeed = 20;
    private int playerAttackProbability = 100;
    private int playerEvasion = 10;
    private int defenseDuration = 1;
    private int fleeGoodProbability = 90;
    private int fleeBadProbability = 35;
    private int minimumHitPercentage = 4;
    private int maxInBattle = 8;
    private boolean freezeCombatantsInBattle = false;
    private int configVersion = 0;
    private Set<Integer> battleIgnoringPlayers = null;
    private boolean onlyOPsSelfDisableTB = true;
    private boolean battleDisabledForAll = false;
    private boolean oldBattleBehaviorEnabled = false;
    private int leaveBattleCooldownSeconds = 5;
    private int aggroStartBattleDistance = 8;
    private int creeperExplodeTurn = 5;
    private boolean creeperStopExplodeOnLeaveBattle = true;
    private boolean creeperAlwaysAllowDamage = true;
    private Set<String> possibleIgnoreHurtDamageSources;
    private Set<String> ignoreHurtDamageSources;
    private boolean playerOnlyBattles = false;

    public Config() {
        this.logger = null;
        this.battleIgnoringPlayers = new HashSet<Integer>();
        this.possibleIgnoreHurtDamageSources = new HashSet<String>();
        this.ignoreHurtDamageSources = new HashSet<String>();
    }

    public Config(Logger logger) {
        this.logger = logger;
        this.battleIgnoringPlayers = new HashSet<Integer>();
        this.possibleIgnoreHurtDamageSources = new HashSet<String>();
        this.ignoreHurtDamageSources = new HashSet<String>();
        this.loadDamageSources();
        File confPath = new File("config/TurnBasedMinecraft/");
        if (!confPath.exists() && !confPath.mkdirs()) {
            logger.error("Failed to create config dir \"config/TurnBasedMinecraft/\"");
            return;
        }
        this.writeDefaultConfig(this.getClass().getResourceAsStream("/assets/com_burnedkirby_turnbasedminecraft/TBM_Config.toml"));
        int internalVersion = this.getConfigFileVersion(new File("config/TurnBasedMinecraft/TBM_Config_DEFAULT.toml"));
        if (internalVersion == 0) {
            logger.error("Failed to check version of internal config file");
            logger.error("Tried path \"config/TurnBasedMinecraft/TBM_Config_DEFAULT.toml\"");
        } else {
            this.configVersion = internalVersion;
        }
        try {
            File testLoad = new File("config/TurnBasedMinecraft/TBM_Config.toml");
            if (!testLoad.exists()) {
                this.writeConfig();
            }
        }
        catch (Throwable t) {
            logger.error("Failed to check/create-new config file");
        }
        File configFile = new File("config/TurnBasedMinecraft/TBM_Config.toml");
        if (!configFile.exists() || !configFile.canRead()) {
            logger.error("Failed to read/parse config file config/TurnBasedMinecraft/TBM_Config.toml");
            return;
        }
        int configVersion = this.getConfigFileVersion(configFile);
        boolean canOverwrite = this.getCanOverwrite(configFile);
        if (configVersion < this.configVersion && canOverwrite) {
            logger.warn("Config file TBM_Config.toml is older version, renaming...");
            this.moveOldConfig();
            try {
                this.writeConfig();
            }
            catch (Throwable t) {
                logger.error("Failed to write config file!");
            }
        }
        Config defaultConfig = Config.FromDefault(logger);
        try {
            this.parseConfig(configFile, defaultConfig);
        }
        catch (Throwable t) {
            logger.error("Failed to parse config file!", t);
        }
    }

    public static Config FromDefault(Logger logger) {
        Config defaultConf = new Config();
        defaultConf.logger = logger;
        defaultConf.loadDamageSources();
        File configFile = new File("config/TurnBasedMinecraft/TBM_Config_DEFAULT.toml");
        try {
            defaultConf.parseConfig(configFile, null);
        }
        catch (IOException e) {
            logger.warn("IOException while parsing default config file", (Throwable)e);
        }
        return defaultConf;
    }

    private void writeConfig() throws IOException {
        int read;
        InputStream is = this.getClass().getResourceAsStream("/assets/com_burnedkirby_turnbasedminecraft/TBM_Config.toml");
        FileOutputStream fos = new FileOutputStream("config/TurnBasedMinecraft/TBM_Config.toml");
        byte[] buf = new byte[1024];
        while ((read = is.read(buf)) > 0) {
            fos.write(buf, 0, read);
        }
        fos.close();
        is.close();
    }

    private void moveOldConfig() {
        File configFile = new File("config/TurnBasedMinecraft/TBM_Config.toml");
        if (configFile.exists()) {
            configFile.renameTo(new File("config/TurnBasedMinecraft/TBM_Config_" + DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(LocalDateTime.now()) + ".toml"));
        }
    }

    private boolean parseConfig(File configFile, @Nullable Config defaultConfig) throws IOException {
        CommentedFileConfig conf = this.getConfigObj(configFile);
        try {
            OptionalInt leave_battle_cooldown = conf.getOptionalInt("server_config.leave_battle_cooldown");
            if (leave_battle_cooldown.isPresent()) {
                this.leaveBattleCooldownSeconds = leave_battle_cooldown.getAsInt();
                if (this.leaveBattleCooldownSeconds < 1) {
                    this.logClampedValue("server_config.leave_battle_cooldown", Integer.toString(this.leaveBattleCooldownSeconds), "1");
                    this.leaveBattleCooldownSeconds = 1;
                } else if (this.leaveBattleCooldownSeconds > 10) {
                    this.logClampedValue("server_config.leave_battle_cooldown", Integer.toString(this.leaveBattleCooldownSeconds), "10");
                    this.leaveBattleCooldownSeconds = 10;
                }
            } else if (defaultConfig != null) {
                this.leaveBattleCooldownSeconds = defaultConfig.leaveBattleCooldownSeconds;
                conf.set("server_config.leave_battle_cooldown", (Object)defaultConfig.leaveBattleCooldownSeconds);
                this.logNotFound("server_config.leave_battle_cooldown", String.valueOf(defaultConfig.leaveBattleCooldownSeconds));
            } else {
                this.leaveBattleCooldownSeconds = 5;
                this.logNotFound("server_config.leave_battle_cooldown", "5");
            }
        }
        catch (Throwable e) {
            this.leaveBattleCooldownSeconds = 5;
            this.logTOMLInvalidValue("server_config.leave_battle_cooldown", "5");
        }
        try {
            OptionalInt aggro_start_battle_max_distance = conf.getOptionalInt("server_config.aggro_start_battle_max_distance");
            if (aggro_start_battle_max_distance.isPresent()) {
                this.aggroStartBattleDistance = aggro_start_battle_max_distance.getAsInt();
                if (this.aggroStartBattleDistance < 5) {
                    this.logClampedValue("server_config.aggro_start_battle_max_distance", Integer.toString(this.aggroStartBattleDistance), "5");
                    this.aggroStartBattleDistance = 5;
                } else if (this.aggroStartBattleDistance > 50) {
                    this.logClampedValue("server_config.aggro_start_battle_max_distance", Integer.toString(this.aggroStartBattleDistance), "50");
                    this.aggroStartBattleDistance = 50;
                }
            } else if (defaultConfig != null) {
                this.aggroStartBattleDistance = defaultConfig.aggroStartBattleDistance;
                conf.set("server_config.aggro_start_battle_max_distance", (Object)defaultConfig.aggroStartBattleDistance);
                this.logNotFound("server_config.aggro_start_battle_max_distance", String.valueOf(defaultConfig.aggroStartBattleDistance));
            } else {
                this.aggroStartBattleDistance = 8;
                this.logNotFound("server_config.aggro_start_battle_max_distance", "8");
            }
        }
        catch (Throwable e) {
            this.aggroStartBattleDistance = 8;
            this.logTOMLInvalidValue("server_config.aggro_start_battle_max_distance", "8");
        }
        try {
            OptionalInt creeper_explode_turn = conf.getOptionalInt("server_config.creeper_explode_turn");
            if (creeper_explode_turn.isPresent()) {
                this.creeperExplodeTurn = creeper_explode_turn.getAsInt();
                if (this.creeperExplodeTurn < 1) {
                    this.logClampedValue("server_config.creeper_explode_turn", Integer.toString(this.creeperExplodeTurn), "1");
                    this.creeperExplodeTurn = 1;
                }
            } else if (defaultConfig != null) {
                this.creeperExplodeTurn = defaultConfig.creeperExplodeTurn;
                conf.set("server_config.creeper_explode_turn", (Object)defaultConfig.creeperExplodeTurn);
                this.logNotFound("server_config.creeper_explode_turn", String.valueOf(defaultConfig.creeperExplodeTurn));
            } else {
                this.creeperExplodeTurn = 5;
                this.logNotFound("server_config.creeper_explode_turn", "5");
            }
        }
        catch (Throwable e) {
            this.creeperExplodeTurn = 5;
            this.logTOMLInvalidValue("server_config.creeper_explode_turn", "5");
        }
        try {
            Boolean creeper_stop_explode_on_leave_battle = (Boolean)conf.get("server_config.creeper_stop_explode_on_leave_battle");
            if (creeper_stop_explode_on_leave_battle != null) {
                this.creeperStopExplodeOnLeaveBattle = creeper_stop_explode_on_leave_battle;
            } else if (defaultConfig != null) {
                this.creeperStopExplodeOnLeaveBattle = defaultConfig.creeperStopExplodeOnLeaveBattle;
                conf.set("server_config.creeper_stop_explode_on_leave_battle", (Object)defaultConfig.creeperStopExplodeOnLeaveBattle);
                this.logNotFound("server_config.creeper_stop_explode_on_leave_battle", String.valueOf(defaultConfig.creeperStopExplodeOnLeaveBattle));
            } else {
                this.creeperStopExplodeOnLeaveBattle = true;
                this.logNotFound("server_config.creeper_stop_explode_on_leave_battle", "true");
            }
        }
        catch (Throwable e) {
            this.creeperStopExplodeOnLeaveBattle = true;
            this.logTOMLInvalidValue("server_config.creeper_stop_explode_on_leave_battle", "true");
        }
        try {
            Boolean creeper_always_allow_damage = (Boolean)conf.get("server_config.creeper_always_allow_damage");
            if (creeper_always_allow_damage != null) {
                this.creeperAlwaysAllowDamage = creeper_always_allow_damage;
            } else if (defaultConfig != null) {
                this.creeperAlwaysAllowDamage = defaultConfig.creeperAlwaysAllowDamage;
                conf.set("server_config.creeper_always_allow_damage", (Object)defaultConfig.creeperAlwaysAllowDamage);
                this.logNotFound("server_config.creeper_always_allow_damage", String.valueOf(defaultConfig.creeperAlwaysAllowDamage));
            } else {
                this.creeperAlwaysAllowDamage = true;
                this.logNotFound("server_config.creeper_always_allow_damage", "true");
            }
        }
        catch (Throwable e) {
            this.creeperAlwaysAllowDamage = true;
            this.logTOMLInvalidValue("server_config.creeper_always_allow_damage", "true");
        }
        try {
            Boolean old_battle_behavior = (Boolean)conf.get("server_config.old_battle_behavior");
            if (old_battle_behavior != null) {
                this.oldBattleBehaviorEnabled = old_battle_behavior;
            } else if (defaultConfig != null) {
                this.oldBattleBehaviorEnabled = defaultConfig.oldBattleBehaviorEnabled;
                conf.set("server_config.old_battle_behavior", (Object)defaultConfig.oldBattleBehaviorEnabled);
                this.logNotFound("server_config.old_battle_behavior", String.valueOf(defaultConfig.oldBattleBehaviorEnabled));
            } else {
                this.oldBattleBehaviorEnabled = false;
                this.logNotFound("server_config.old_battle_behavior", "false");
            }
        }
        catch (Throwable e) {
            this.oldBattleBehaviorEnabled = false;
            this.logTOMLInvalidValue("server_config.old_battle_behavior", "false");
        }
        try {
            Boolean anyone_can_disable_tbm_for_self = (Boolean)conf.get("server_config.anyone_can_disable_tbm_for_self");
            if (anyone_can_disable_tbm_for_self != null) {
                this.onlyOPsSelfDisableTB = anyone_can_disable_tbm_for_self == false;
            } else if (defaultConfig != null) {
                this.onlyOPsSelfDisableTB = defaultConfig.onlyOPsSelfDisableTB;
                conf.set("server_config.anyone_can_disable_tbm_for_self", (Object)defaultConfig.onlyOPsSelfDisableTB);
                this.logNotFound("server_config.anyone_can_disable_tbm_for_self", String.valueOf(defaultConfig.onlyOPsSelfDisableTB));
            } else {
                this.onlyOPsSelfDisableTB = true;
                this.logNotFound("server_config.anyone_can_disable_tbm_for_self", "false");
            }
        }
        catch (Throwable e) {
            this.onlyOPsSelfDisableTB = true;
            this.logTOMLInvalidValue("server_config.anyone_can_disable_tbm_for_self", "false");
        }
        try {
            OptionalInt max_in_battle = conf.getOptionalInt("server_config.max_in_battle");
            if (max_in_battle.isPresent()) {
                this.maxInBattle = max_in_battle.getAsInt();
                if (this.maxInBattle < 2) {
                    this.logClampedValue("server_config.max_in_battle", Integer.toString(this.maxInBattle), "2");
                    this.maxInBattle = 2;
                }
            } else if (defaultConfig != null) {
                this.maxInBattle = defaultConfig.maxInBattle;
                conf.set("server_config.max_in_battle", (Object)defaultConfig.maxInBattle);
                this.logNotFound("server_config.max_in_battle", String.valueOf(defaultConfig.maxInBattle));
            } else {
                this.maxInBattle = 8;
                this.logNotFound("server_config.max_in_battle", "8");
            }
        }
        catch (Throwable e) {
            this.maxInBattle = 8;
            this.logTOMLInvalidValue("server_config.max_in_battle", "8");
        }
        try {
            Boolean freeze_battle_combatants = (Boolean)conf.get("server_config.freeze_battle_combatants");
            if (freeze_battle_combatants != null) {
                this.freezeCombatantsInBattle = freeze_battle_combatants;
            } else if (defaultConfig != null) {
                this.freezeCombatantsInBattle = defaultConfig.freezeCombatantsInBattle;
                conf.set("server_config.freeze_battle_combatants", (Object)defaultConfig.freezeCombatantsInBattle);
                this.logNotFound("server_config.freeze_battle_combatants", String.valueOf(defaultConfig.freezeCombatantsInBattle));
            } else {
                this.freezeCombatantsInBattle = false;
                this.logNotFound("server_config.freeze_battle_combatants", "false");
            }
        }
        catch (Throwable e) {
            this.freezeCombatantsInBattle = false;
            this.logTOMLInvalidValue("server_config.freeze_battle_combatants", "false");
        }
        try {
            Collection ignore_battle_types = (Collection)conf.get("server_config.ignore_battle_types");
            if (ignore_battle_types != null) {
                this.ignoreBattleTypes.addAll(ignore_battle_types);
            } else if (defaultConfig != null) {
                this.ignoreBattleTypes = defaultConfig.ignoreBattleTypes;
                List ignoreList = defaultConfig.ignoreBattleTypes.stream().toList();
                conf.set("server_config.ignore_battle_types", ignoreList);
                this.logNotFound("server_config.ignore_battle_types");
            } else {
                this.ignoreBattleTypes.add("passive");
                this.ignoreBattleTypes.add("boss");
                this.logNotFound("server_config.ignore_battle_types");
            }
        }
        catch (Throwable e) {
            this.ignoreBattleTypes.add("passive");
            this.ignoreBattleTypes.add("boss");
            this.logTOMLInvalidValue("server_config.ignore_battle_types");
        }
        try {
            OptionalInt player_speed = conf.getOptionalInt("server_config.player_speed");
            if (player_speed.isPresent()) {
                this.playerSpeed = player_speed.getAsInt();
            } else if (defaultConfig != null) {
                this.playerSpeed = defaultConfig.playerSpeed;
                conf.set("server_config.player_speed", (Object)defaultConfig.playerSpeed);
                this.logNotFound("server_config.player_speed", String.valueOf(defaultConfig.playerSpeed));
            } else {
                this.playerSpeed = 50;
                this.logNotFound("server_config.player_speed", "50");
            }
        }
        catch (Throwable e) {
            this.playerSpeed = 50;
            this.logTOMLInvalidValue("server_config.player_speed", "50");
        }
        try {
            OptionalInt player_haste_speed = conf.getOptionalInt("server_config.player_haste_speed");
            if (player_haste_speed.isPresent()) {
                this.playerHasteSpeed = player_haste_speed.getAsInt();
            } else if (defaultConfig != null) {
                this.playerHasteSpeed = defaultConfig.playerHasteSpeed;
                conf.set("server_config.player_haste_speed", (Object)defaultConfig.playerHasteSpeed);
                this.logNotFound("server_config.player_haste_speed", String.valueOf(defaultConfig.playerHasteSpeed));
            } else {
                this.playerHasteSpeed = 80;
                this.logNotFound("server_config.player_haste_speed", "80");
            }
        }
        catch (Throwable e) {
            this.playerHasteSpeed = 80;
            this.logTOMLInvalidValue("server_config.player_haste_speed", "80");
        }
        try {
            OptionalInt player_slow_speed = conf.getOptionalInt("server_config.player_slow_speed");
            if (player_slow_speed.isPresent()) {
                this.playerSlowSpeed = player_slow_speed.getAsInt();
            } else if (defaultConfig != null) {
                this.playerSlowSpeed = defaultConfig.playerSlowSpeed;
                conf.set("server_config.player_slow_speed", (Object)defaultConfig.playerSlowSpeed);
                this.logNotFound("server_config.player_slow_speed", String.valueOf(defaultConfig.playerSlowSpeed));
            } else {
                this.playerSlowSpeed = 20;
                this.logNotFound("server_config.player_slow_speed", "20");
            }
        }
        catch (Throwable e) {
            this.playerSlowSpeed = 20;
            this.logTOMLInvalidValue("server_config.player_slow_speed", "20");
        }
        try {
            OptionalInt player_attack_probability = conf.getOptionalInt("server_config.player_attack_probability");
            if (player_attack_probability.isPresent()) {
                this.playerAttackProbability = player_attack_probability.getAsInt();
            } else if (defaultConfig != null) {
                this.playerAttackProbability = defaultConfig.playerAttackProbability;
                conf.set("server_config.player_attack_probability", (Object)defaultConfig.playerAttackProbability);
                this.logNotFound("server_config.player_attack_probability", String.valueOf(defaultConfig.playerAttackProbability));
            } else {
                this.playerAttackProbability = 90;
                this.logNotFound("server_config.player_attack_probability", "90");
            }
        }
        catch (Throwable e) {
            this.playerAttackProbability = 90;
            this.logTOMLInvalidValue("server_config.player_attack_probability", "90");
        }
        try {
            OptionalInt player_evasion = conf.getOptionalInt("server_config.player_evasion");
            if (player_evasion.isPresent()) {
                this.playerEvasion = player_evasion.getAsInt();
            } else if (defaultConfig != null) {
                this.playerEvasion = defaultConfig.playerEvasion;
                conf.set("server_config.player_evasion", (Object)defaultConfig.playerEvasion);
                this.logNotFound("server_config.player_evasion", String.valueOf(defaultConfig.playerEvasion));
            } else {
                this.playerEvasion = 10;
                this.logNotFound("server_config.player_evasion", "10");
            }
        }
        catch (Throwable e) {
            this.playerEvasion = 10;
            this.logTOMLInvalidValue("server_config.player_evasion", "10");
        }
        try {
            OptionalInt defense_duration = conf.getOptionalInt("server_config.defense_duration");
            if (defense_duration.isPresent()) {
                this.defenseDuration = defense_duration.getAsInt();
                if (this.defenseDuration < 0) {
                    this.logClampedValue("server_config.defense_duration", Integer.toString(this.defenseDuration), "0");
                    this.defenseDuration = 0;
                }
            } else if (defaultConfig != null) {
                this.defenseDuration = defaultConfig.defenseDuration;
                conf.set("server_config.defense_duration", (Object)defaultConfig.defenseDuration);
                this.logNotFound("server_config.defense_duration", String.valueOf(defaultConfig.defenseDuration));
            } else {
                this.defenseDuration = 1;
                this.logNotFound("server_config.defense_duration", "1");
            }
        }
        catch (Throwable e) {
            this.defenseDuration = 1;
            this.logTOMLInvalidValue("server_config.defense_duration", "1");
        }
        try {
            OptionalInt flee_good_probability = conf.getOptionalInt("server_config.flee_good_probability");
            if (flee_good_probability.isPresent()) {
                this.fleeGoodProbability = flee_good_probability.getAsInt();
            } else if (defaultConfig != null) {
                this.fleeGoodProbability = defaultConfig.fleeGoodProbability;
                conf.set("server_config.flee_good_probability", (Object)defaultConfig.fleeGoodProbability);
                this.logNotFound("server_config.flee_good_probability", String.valueOf(defaultConfig.fleeGoodProbability));
            } else {
                this.fleeGoodProbability = 90;
                this.logNotFound("server_config.flee_good_probability", "90");
            }
        }
        catch (Throwable e) {
            this.fleeGoodProbability = 90;
            this.logTOMLInvalidValue("server_config.flee_good_probability", "90");
        }
        try {
            OptionalInt flee_bad_probability = conf.getOptionalInt("server_config.flee_bad_probability");
            if (flee_bad_probability.isPresent()) {
                this.fleeBadProbability = flee_bad_probability.getAsInt();
            } else if (defaultConfig != null) {
                this.fleeBadProbability = defaultConfig.fleeBadProbability;
                conf.set("server_config.flee_bad_probability", (Object)defaultConfig.fleeBadProbability);
                this.logNotFound("server_config.flee_bad_probability", String.valueOf(defaultConfig.fleeBadProbability));
            } else {
                this.fleeBadProbability = 35;
                this.logNotFound("server_config.flee_bad_probability", "35");
            }
        }
        catch (Throwable e) {
            this.fleeBadProbability = 35;
            this.logTOMLInvalidValue("server_config.flee_bad_probability", "35");
        }
        try {
            OptionalInt minimum_hit_percentage = conf.getOptionalInt("server_config.minimum_hit_percentage");
            if (minimum_hit_percentage.isPresent()) {
                this.minimumHitPercentage = minimum_hit_percentage.getAsInt();
                if (this.minimumHitPercentage < 1) {
                    this.logClampedValue("server_config.minimum_hit_percentage", Integer.toString(this.minimumHitPercentage), "1");
                    this.minimumHitPercentage = 1;
                }
            } else if (defaultConfig != null) {
                this.minimumHitPercentage = defaultConfig.minimumHitPercentage;
                conf.set("server_config.minimum_hit_percentage", (Object)defaultConfig.minimumHitPercentage);
                this.logNotFound("server_config.minimum_hit_percentage", String.valueOf(defaultConfig.minimumHitPercentage));
            } else {
                this.minimumHitPercentage = 4;
                this.logNotFound("server_config.minimum_hit_percentage", "4");
            }
        }
        catch (Throwable e) {
            this.minimumHitPercentage = 4;
            this.logTOMLInvalidValue("server_config.minimum_hit_percentage", "4");
        }
        try {
            OptionalInt battle_turn_time_seconds = conf.getOptionalInt("server_config.battle_turn_time_seconds");
            if (battle_turn_time_seconds.isPresent()) {
                this.battleDecisionDurationNanos = (long)battle_turn_time_seconds.getAsInt() * 1000000000L;
                if (this.battleDecisionDurationNanos < 5000000000L) {
                    this.battleDecisionDurationNanos = 5000000000L;
                    this.logClampedValue("server_config.battle_turn_time_seconds", Integer.toString(battle_turn_time_seconds.getAsInt()), Long.toString(5L));
                } else if (this.battleDecisionDurationNanos > 60000000000L) {
                    this.battleDecisionDurationNanos = 60000000000L;
                    this.logClampedValue("server_config.battle_turn_time_seconds", Integer.toString(battle_turn_time_seconds.getAsInt()), Long.toString(60L));
                }
            } else if (defaultConfig != null) {
                this.battleDecisionDurationNanos = defaultConfig.battleDecisionDurationNanos;
                conf.set("server_config.battle_turn_time_seconds", (Object)(defaultConfig.battleDecisionDurationNanos / 1000000000L));
                this.logNotFound("server_config.battle_turn_time_seconds", String.valueOf(defaultConfig.battleDecisionDurationNanos));
            } else {
                this.battleDecisionDurationNanos = 15000000000L;
                this.logNotFound("server_config.battle_turn_time_seconds", "15");
            }
        }
        catch (Throwable e) {
            this.battleDecisionDurationNanos = 15000000000L;
            this.logTOMLInvalidValue("server_config.battle_turn_time_seconds", "15");
        }
        try {
            Boolean battle_turn_wait_forever = (Boolean)conf.get("server_config.battle_turn_wait_forever");
            if (battle_turn_wait_forever != null) {
                this.battleDecisionDurationForever = battle_turn_wait_forever;
            } else if (defaultConfig != null) {
                this.battleDecisionDurationForever = defaultConfig.battleDecisionDurationForever;
                conf.set("server_config.battle_turn_wait_forever", (Object)defaultConfig.battleDecisionDurationForever);
                this.logNotFound("server_config.battle_turn_wait_forever", String.valueOf(defaultConfig.battleDecisionDurationForever));
            } else {
                this.battleDecisionDurationForever = false;
                this.logNotFound("server_config.battle_turn_wait_forever", "false");
            }
        }
        catch (Throwable e) {
            this.battleDecisionDurationForever = false;
            this.logTOMLInvalidValue("server_config.battle_turn_wait_forever", "false");
        }
        try {
            Collection damage_sources = (Collection)conf.get("server_config.ignore_damage_sources");
            if (damage_sources != null) {
                for (String source : damage_sources) {
                    if (!this.possibleIgnoreHurtDamageSources.contains(source)) continue;
                    this.ignoreHurtDamageSources.add(source);
                }
            } else if (defaultConfig != null) {
                this.ignoreHurtDamageSources = defaultConfig.ignoreHurtDamageSources;
                List ignSourcesList = defaultConfig.ignoreHurtDamageSources.stream().toList();
                conf.set("server_config.ignore_damage_sources", ignSourcesList);
                this.logNotFound("server_config.ignore_damage_sources");
            }
        }
        catch (Throwable e) {
            this.logTOMLInvalidValue("server_config.ignore_damage_sources");
        }
        try {
            Boolean is_only_player_battles_enabled = (Boolean)conf.get("server_config.player_only_battles");
            if (is_only_player_battles_enabled != null) {
                this.playerOnlyBattles = is_only_player_battles_enabled;
            } else if (defaultConfig != null) {
                this.playerOnlyBattles = defaultConfig.playerOnlyBattles;
                conf.set("server_config.player_only_battles", (Object)defaultConfig.playerOnlyBattles);
                this.logNotFound("server_config.player_only_battles", String.valueOf(defaultConfig.playerOnlyBattles));
            } else {
                this.playerOnlyBattles = false;
                this.logNotFound("server_config.player_only_battles", "false");
            }
        }
        catch (Throwable e) {
            this.playerOnlyBattles = false;
            this.logTOMLInvalidValue("server_config.player_only_battles", "false");
        }
        Collection entities = null;
        try {
            entities = (Collection)conf.get("server_config.entity");
        }
        catch (Throwable e) {
            this.logTOMLInvalidValue("server_config.entity");
        }
        if (entities != null) {
            EntityInfo eInfo;
            for (com.electronwill.nightconfig.core.Config nestedConf : entities) {
                String name;
                block302: {
                    block301: {
                        block300: {
                            eInfo = new EntityInfo();
                            if (nestedConf.contains("name") && nestedConf.contains("custom_name")) {
                                this.logger.error("Entity cannot have both \"name\" (" + String.valueOf(nestedConf.get("name")) + ") and \"custom_name\" (" + String.valueOf(nestedConf.get("custom_name")) + ") entries");
                                continue;
                            }
                            if (nestedConf.contains("name") && nestedConf.contains("player_name")) {
                                this.logger.error("Entity cannot have both \"name\" (" + String.valueOf(nestedConf.get("name")) + ") and \"player_name\" (" + String.valueOf(nestedConf.get("player_name")) + ") entries");
                                continue;
                            }
                            if (nestedConf.contains("custom_name") && nestedConf.contains("player_name")) {
                                this.logger.error("Entity cannot have both \"custom_name\" (" + String.valueOf(nestedConf.get("custom_name")) + ") and \"player_name\" (" + String.valueOf(nestedConf.get("player_name")) + ") entries");
                                continue;
                            }
                            if (nestedConf.contains("name")) {
                                try {
                                    eInfo.classType = Class.forName((String)nestedConf.get("name"));
                                    name = eInfo.classType.getName();
                                    break block300;
                                }
                                catch (ClassNotFoundException e) {
                                    this.logger.error("Entity with class name \"" + String.valueOf(nestedConf.get("name")) + "\" not found, skipping...");
                                    continue;
                                }
                            }
                            if (nestedConf.contains("custom_name")) {
                                try {
                                    name = eInfo.customName = (String)nestedConf.get("custom_name");
                                    break block300;
                                }
                                catch (ClassCastException e) {
                                    this.logger.error("Entity with invalid custom_name (must be a string), skipping...");
                                    continue;
                                }
                            }
                            if (nestedConf.contains("player_name")) {
                                try {
                                    name = eInfo.playerName = (String)nestedConf.get("player_name");
                                    break block300;
                                }
                                catch (ClassCastException e) {
                                    this.logger.error("Entity with invalid player_name (must be a string), skipping...");
                                    continue;
                                }
                            }
                            this.logger.error("Entity must have \"name\" or \"custom_name\" or \"player_name\" entry");
                            continue;
                        }
                        if (eInfo.playerName.isEmpty()) {
                            try {
                                eInfo.attackPower = nestedConf.getInt("attack_power");
                                if (eInfo.attackPower < 0) {
                                    this.logClampedValueEntity("attack_power", name, Integer.toString(eInfo.attackPower), "0");
                                    eInfo.attackPower = 0;
                                }
                            }
                            catch (Throwable e) {
                                if (defaultConfig != null) {
                                    if (eInfo.classType != null && defaultConfig.entityInfoMap.containsKey(eInfo.classType.getName())) {
                                        eInfo.attackPower = defaultConfig.entityInfoMap.get((Object)eInfo.classType.getName()).attackPower;
                                        this.logEntityInvalidValue("attack_power", name, String.valueOf(eInfo.attackPower));
                                        nestedConf.set("attack_power", (Object)eInfo.attackPower);
                                    } else if (!eInfo.customName.isEmpty() && defaultConfig.customEntityInfoMap.containsKey(eInfo.customName)) {
                                        eInfo.attackPower = defaultConfig.customEntityInfoMap.get((Object)eInfo.customName).attackPower;
                                        this.logEntityInvalidValue("attack_power", name, String.valueOf(eInfo.attackPower));
                                        nestedConf.set("attack_power", (Object)eInfo.attackPower);
                                    } else {
                                        this.logEntityInvalidValue("attack_power", name, "3");
                                        eInfo.attackPower = 3;
                                        nestedConf.set("attack_power", (Object)eInfo.attackPower);
                                    }
                                }
                                this.logEntityInvalidValue("attack_power", name, "3");
                                eInfo.attackPower = 3;
                            }
                        }
                        try {
                            eInfo.attackProbability = nestedConf.getInt("attack_probability");
                            if (eInfo.attackProbability < 0) {
                                this.logClampedValueEntity("attack_probability", name, Integer.toString(eInfo.attackProbability), "0");
                                eInfo.attackProbability = 0;
                            } else if (eInfo.attackProbability > 100) {
                                this.logClampedValueEntity("attack_probability", name, Integer.toString(eInfo.attackProbability), "100");
                                eInfo.attackProbability = 100;
                            }
                        }
                        catch (Throwable e) {
                            if (defaultConfig != null) {
                                if (eInfo.classType != null && defaultConfig.entityInfoMap.containsKey(eInfo.classType.getName())) {
                                    eInfo.attackProbability = defaultConfig.entityInfoMap.get((Object)eInfo.classType.getName()).attackProbability;
                                    this.logEntityInvalidValue("attack_probability", name, String.valueOf(eInfo.attackProbability));
                                    nestedConf.set("attack_probability", (Object)eInfo.attackProbability);
                                } else if (!eInfo.customName.isEmpty() && defaultConfig.customEntityInfoMap.containsKey(eInfo.customName)) {
                                    eInfo.attackProbability = defaultConfig.customEntityInfoMap.get((Object)eInfo.customName).attackProbability;
                                    this.logEntityInvalidValue("attack_probability", name, String.valueOf(eInfo.attackProbability));
                                    nestedConf.set("attack_probability", (Object)eInfo.attackProbability);
                                } else if (!eInfo.playerName.isEmpty() && defaultConfig.customPlayerInfoMap.containsKey(eInfo.playerName)) {
                                    eInfo.attackProbability = defaultConfig.customPlayerInfoMap.get((Object)eInfo.playerName).attackProbability;
                                    this.logEntityInvalidValue("attack_probability", name, String.valueOf(eInfo.attackProbability));
                                    nestedConf.set("attack_probability", (Object)eInfo.attackProbability);
                                } else {
                                    this.logEntityInvalidValue("attack_probability", name, "30");
                                    eInfo.attackProbability = 30;
                                    nestedConf.set("attack_probability", (Object)eInfo.attackProbability);
                                }
                            }
                            this.logEntityInvalidValue("attack_probability", name, "30");
                            eInfo.attackProbability = 30;
                        }
                        try {
                            eInfo.attackEffect = EntityInfo.Effect.fromString((String)nestedConf.get("attack_effect"));
                            if (eInfo.attackEffect == EntityInfo.Effect.UNKNOWN) break block301;
                            try {
                                eInfo.attackEffectProbability = nestedConf.getInt("attack_effect_probability");
                                if (eInfo.attackEffectProbability < 0) {
                                    this.logClampedValueEntity("attack_effect_probability", name, Integer.toString(eInfo.attackEffectProbability), "1");
                                    eInfo.attackEffectProbability = 1;
                                } else if (eInfo.attackEffectProbability > 100) {
                                    this.logClampedValueEntity("attack_effect_probability", name, Integer.toString(eInfo.attackEffectProbability), "100");
                                    eInfo.attackEffectProbability = 100;
                                }
                            }
                            catch (Throwable e) {
                                eInfo.attackEffect = EntityInfo.Effect.UNKNOWN;
                                this.logger.warn("Entity \"" + name + "\" has specified attack_effect but attack_effect_probability is invalid, unsetting attack_effect");
                            }
                        }
                        catch (Throwable e) {
                            eInfo.attackEffect = EntityInfo.Effect.UNKNOWN;
                            this.logEntityInvalidValue("attack_effect", name, "unknown");
                        }
                    }
                    if (eInfo.playerName.isEmpty()) {
                        try {
                            eInfo.attackVariance = nestedConf.getInt("attack_variance");
                            if (eInfo.attackVariance < 0) {
                                this.logClampedValueEntity("attack_variance", name, Integer.toString(eInfo.attackVariance), "0");
                                eInfo.attackVariance = 0;
                            }
                        }
                        catch (Throwable e) {
                            if (defaultConfig != null) {
                                if (eInfo.classType != null && defaultConfig.entityInfoMap.containsKey(eInfo.classType.getName())) {
                                    eInfo.attackVariance = defaultConfig.entityInfoMap.get((Object)eInfo.classType.getName()).attackVariance;
                                    this.logEntityInvalidValue("attack_variance", name, String.valueOf(eInfo.attackVariance));
                                    nestedConf.set("attack_variance", (Object)eInfo.attackVariance);
                                } else if (!eInfo.customName.isEmpty() && defaultConfig.customEntityInfoMap.containsKey(eInfo.customName)) {
                                    eInfo.attackVariance = defaultConfig.customEntityInfoMap.get((Object)eInfo.customName).attackVariance;
                                    this.logEntityInvalidValue("attack_variance", name, String.valueOf(eInfo.attackVariance));
                                    nestedConf.set("attack_variance", (Object)eInfo.attackVariance);
                                } else {
                                    eInfo.attackVariance = 0;
                                    this.logEntityInvalidValue("attack_variance", name, "0");
                                    nestedConf.set("attack_variance", (Object)eInfo.attackVariance);
                                }
                            }
                            eInfo.attackVariance = 0;
                            this.logEntityInvalidValue("attack_variance", name, "0");
                        }
                        try {
                            eInfo.defenseDamage = nestedConf.getInt("defense_damage");
                            if (eInfo.defenseDamage < 0) {
                                this.logClampedValueEntity("defense_damage", name, Integer.toString(eInfo.defenseDamage), "0");
                                eInfo.defenseDamage = 0;
                                break block302;
                            }
                            if (eInfo.defenseDamage == 0) break block302;
                            try {
                                eInfo.defenseDamageProbability = nestedConf.getInt("defense_damage_probability");
                                if (eInfo.defenseDamageProbability < 1) {
                                    this.logClampedValueEntity("defense_damage_probability", name, Integer.toString(eInfo.defenseDamageProbability), "1");
                                    eInfo.defenseDamageProbability = 1;
                                } else if (eInfo.defenseDamageProbability > 100) {
                                    this.logClampedValueEntity("defense_damage_probability", name, Integer.toString(eInfo.defenseDamageProbability), "100");
                                    eInfo.defenseDamageProbability = 100;
                                }
                            }
                            catch (Throwable e) {
                                eInfo.defenseDamage = 0;
                                this.logger.warn("Entity \"" + name + "\" has specified defense_damage but defense_damage_probability is invalid, disabling defense_damage");
                            }
                        }
                        catch (Throwable e) {
                            eInfo.defenseDamage = 0;
                            this.logEntityInvalidValue("defense_damage", name, "0");
                        }
                    }
                }
                try {
                    eInfo.evasion = nestedConf.getInt("evasion");
                    if (eInfo.evasion < 0) {
                        this.logClampedValueEntity("evasion", name, Integer.toString(eInfo.evasion), "0");
                        eInfo.evasion = 0;
                    } else if (eInfo.evasion > 100) {
                        this.logClampedValueEntity("evasion", name, Integer.toString(eInfo.evasion), "100");
                        eInfo.evasion = 100;
                    }
                }
                catch (Throwable e) {
                    if (defaultConfig != null) {
                        if (eInfo.classType != null && defaultConfig.entityInfoMap.containsKey(eInfo.classType.getName())) {
                            eInfo.evasion = defaultConfig.entityInfoMap.get((Object)eInfo.classType.getName()).evasion;
                            this.logEntityInvalidValue("evasion", name, String.valueOf(eInfo.evasion));
                            nestedConf.set("evasion", (Object)eInfo.evasion);
                        } else if (!eInfo.customName.isEmpty() && defaultConfig.customEntityInfoMap.containsKey(eInfo.customName)) {
                            eInfo.evasion = defaultConfig.customEntityInfoMap.get((Object)eInfo.customName).evasion;
                            this.logEntityInvalidValue("evasion", name, String.valueOf(eInfo.evasion));
                            nestedConf.set("evasion", (Object)eInfo.evasion);
                        } else if (!eInfo.playerName.isEmpty() && defaultConfig.customPlayerInfoMap.containsKey(eInfo.playerName)) {
                            eInfo.evasion = defaultConfig.customPlayerInfoMap.get((Object)eInfo.playerName).evasion;
                            this.logEntityInvalidValue("evasion", name, String.valueOf(eInfo.evasion));
                            nestedConf.set("evasion", (Object)eInfo.evasion);
                        } else {
                            this.logEntityInvalidValue("evasion", name, "7");
                            eInfo.evasion = 7;
                            nestedConf.set("evasion", (Object)eInfo.evasion);
                        }
                    }
                    this.logEntityInvalidValue("evasion", name, "7");
                    eInfo.evasion = 7;
                }
                try {
                    eInfo.speed = nestedConf.getInt("speed");
                }
                catch (Throwable e) {
                    if (defaultConfig != null) {
                        if (eInfo.classType != null && defaultConfig.entityInfoMap.containsKey(eInfo.classType.getName())) {
                            eInfo.speed = defaultConfig.entityInfoMap.get((Object)eInfo.classType.getName()).speed;
                            this.logEntityInvalidValue("speed", name, String.valueOf(eInfo.speed));
                            nestedConf.set("speed", (Object)eInfo.speed);
                        } else if (!eInfo.customName.isEmpty() && defaultConfig.customEntityInfoMap.containsKey(eInfo.customName)) {
                            eInfo.speed = defaultConfig.customEntityInfoMap.get((Object)eInfo.customName).speed;
                            this.logEntityInvalidValue("speed", name, String.valueOf(eInfo.speed));
                            nestedConf.set("speed", (Object)eInfo.speed);
                        } else if (!eInfo.playerName.isEmpty() && defaultConfig.customPlayerInfoMap.containsKey(eInfo.playerName)) {
                            eInfo.speed = defaultConfig.customPlayerInfoMap.get((Object)eInfo.playerName).speed;
                            this.logEntityInvalidValue("speed", name, String.valueOf(eInfo.speed));
                            nestedConf.set("speed", (Object)eInfo.speed);
                        } else {
                            this.logEntityInvalidValue("speed", name, "49");
                            eInfo.speed = 49;
                            nestedConf.set("speed", (Object)eInfo.speed);
                        }
                    }
                    this.logEntityInvalidValue("speed", name, "49");
                    eInfo.speed = 49;
                }
                try {
                    eInfo.hasteSpeed = nestedConf.getInt("haste_speed");
                }
                catch (Throwable e) {
                    if (defaultConfig != null) {
                        if (eInfo.classType != null && defaultConfig.entityInfoMap.containsKey(eInfo.classType.getName())) {
                            eInfo.hasteSpeed = defaultConfig.entityInfoMap.get((Object)eInfo.classType.getName()).hasteSpeed;
                            this.logEntityInvalidValue("haste_speed", name, String.valueOf(eInfo.hasteSpeed));
                            nestedConf.set("haste_speed", (Object)eInfo.hasteSpeed);
                        } else if (!eInfo.customName.isEmpty() && defaultConfig.customEntityInfoMap.containsKey(eInfo.customName)) {
                            eInfo.hasteSpeed = defaultConfig.customEntityInfoMap.get((Object)eInfo.customName).hasteSpeed;
                            this.logEntityInvalidValue("haste_speed", name, String.valueOf(eInfo.hasteSpeed));
                            nestedConf.set("haste_speed", (Object)eInfo.hasteSpeed);
                        } else if (!eInfo.playerName.isEmpty() && defaultConfig.customPlayerInfoMap.containsKey(eInfo.playerName)) {
                            eInfo.hasteSpeed = defaultConfig.customPlayerInfoMap.get((Object)eInfo.playerName).hasteSpeed;
                            this.logEntityInvalidValue("haste_speed", name, String.valueOf(eInfo.hasteSpeed));
                            nestedConf.set("haste_speed", (Object)eInfo.hasteSpeed);
                        } else {
                            this.logEntityInvalidValue("haste_speed", name, "80");
                            eInfo.hasteSpeed = 80;
                            nestedConf.set("haste_speed", (Object)eInfo.hasteSpeed);
                        }
                    }
                    this.logEntityInvalidValue("haste_speed", name, "80");
                    eInfo.hasteSpeed = 80;
                }
                try {
                    eInfo.slowSpeed = nestedConf.getInt("slow_speed");
                }
                catch (Throwable e) {
                    if (defaultConfig != null) {
                        if (eInfo.classType != null && defaultConfig.entityInfoMap.containsKey(eInfo.classType.getName())) {
                            eInfo.slowSpeed = defaultConfig.entityInfoMap.get((Object)eInfo.classType.getName()).slowSpeed;
                            this.logEntityInvalidValue("slow_speed", name, String.valueOf(eInfo.slowSpeed));
                            nestedConf.set("slow_speed", (Object)eInfo.slowSpeed);
                        } else if (!eInfo.customName.isEmpty() && defaultConfig.customEntityInfoMap.containsKey(eInfo.customName)) {
                            eInfo.slowSpeed = defaultConfig.customEntityInfoMap.get((Object)eInfo.customName).slowSpeed;
                            this.logEntityInvalidValue("slow_speed", name, String.valueOf(eInfo.slowSpeed));
                            nestedConf.set("slow_speed", (Object)eInfo.slowSpeed);
                        } else if (!eInfo.playerName.isEmpty() && defaultConfig.customPlayerInfoMap.containsKey(eInfo.playerName)) {
                            eInfo.slowSpeed = defaultConfig.customPlayerInfoMap.get((Object)eInfo.playerName).slowSpeed;
                            this.logEntityInvalidValue("slow_speed", name, String.valueOf(eInfo.slowSpeed));
                            nestedConf.set("slow_speed", (Object)eInfo.slowSpeed);
                        } else {
                            this.logEntityInvalidValue("slow_speed", name, "20");
                            eInfo.slowSpeed = 20;
                            nestedConf.set("slow_speed", (Object)eInfo.slowSpeed);
                        }
                    }
                    this.logEntityInvalidValue("slow_speed", name, "20");
                    eInfo.slowSpeed = 20;
                }
                if (eInfo.playerName.isEmpty()) {
                    try {
                        eInfo.ignoreBattle = (Boolean)nestedConf.get("ignore_battle");
                    }
                    catch (ClassCastException e) {
                        this.logEntityInvalidValue("ignore_battle", name, "false");
                        nestedConf.set("ignore_battle", (Object)"false");
                        eInfo.ignoreBattle = false;
                    }
                    catch (NullPointerException e) {
                        this.logEntityMissingRequiredValue("ignore_battle", name, "false");
                        nestedConf.set("ignore_battle", (Object)"false");
                        eInfo.ignoreBattle = false;
                    }
                    try {
                        eInfo.category = (String)nestedConf.get("category");
                    }
                    catch (Throwable e) {
                        if (defaultConfig != null) {
                            if (eInfo.classType != null && defaultConfig.entityInfoMap.containsKey(eInfo.classType.getName())) {
                                eInfo.category = defaultConfig.entityInfoMap.get((Object)eInfo.classType.getName()).category;
                                this.logEntityInvalidValue("category", name, String.valueOf(eInfo.category));
                                nestedConf.set("category", (Object)eInfo.category);
                            } else if (!eInfo.customName.isEmpty() && defaultConfig.customEntityInfoMap.containsKey(eInfo.customName)) {
                                eInfo.category = defaultConfig.customEntityInfoMap.get((Object)eInfo.customName).category;
                                this.logEntityInvalidValue("category", name, String.valueOf(eInfo.category));
                                nestedConf.set("category", (Object)eInfo.category);
                            } else {
                                this.logEntityInvalidValue("category", name, "30");
                                nestedConf.set("category", (Object)"unknown");
                                eInfo.category = "unknown";
                            }
                        }
                        this.logEntityInvalidValue("category", name, "unknown");
                        nestedConf.set("category", (Object)"unknown");
                        eInfo.category = "unknown";
                    }
                    try {
                        eInfo.decisionAttack = nestedConf.getInt("decision_attack_probability");
                        if (eInfo.decisionAttack < 0) {
                            this.logClampedValueEntity("decision_attack_probability", name, Integer.toString(eInfo.decisionAttack), "0");
                            eInfo.decisionAttack = 0;
                        } else if (eInfo.decisionAttack > 100) {
                            this.logClampedValueEntity("decision_attack_probability", name, Integer.toString(eInfo.decisionAttack), "100");
                            eInfo.decisionAttack = 100;
                        }
                    }
                    catch (Throwable e) {
                        if (defaultConfig != null) {
                            if (eInfo.classType != null && defaultConfig.entityInfoMap.containsKey(eInfo.classType.getName())) {
                                eInfo.decisionAttack = defaultConfig.entityInfoMap.get((Object)eInfo.classType.getName()).decisionAttack;
                                this.logEntityInvalidValue("decision_attack_probability", name, String.valueOf(eInfo.decisionAttack));
                                nestedConf.set("decision_attack_probability", (Object)eInfo.decisionAttack);
                            } else if (!eInfo.customName.isEmpty() && defaultConfig.customEntityInfoMap.containsKey(eInfo.customName)) {
                                eInfo.decisionAttack = defaultConfig.customEntityInfoMap.get((Object)eInfo.customName).decisionAttack;
                                this.logEntityInvalidValue("decision_attack_probability", name, String.valueOf(eInfo.decisionAttack));
                                nestedConf.set("decision_attack_probability", (Object)eInfo.decisionAttack);
                            } else {
                                this.logEntityInvalidValue("decision_attack_probability", name, "70");
                                eInfo.decisionAttack = 70;
                                nestedConf.set("decision_attack_probability", (Object)eInfo.decisionAttack);
                            }
                        }
                        this.logEntityInvalidValue("decision_attack_probability", name, "70");
                        eInfo.decisionAttack = 70;
                    }
                    try {
                        eInfo.decisionDefend = nestedConf.getInt("decision_defend_probability");
                        if (eInfo.decisionDefend < 0) {
                            this.logClampedValueEntity("decision_defend_probability", name, Integer.toString(eInfo.decisionDefend), "0");
                            eInfo.decisionDefend = 0;
                        } else if (eInfo.decisionDefend > 100) {
                            this.logClampedValueEntity("decision_defend_probability", name, Integer.toString(eInfo.decisionDefend), "100");
                            eInfo.decisionDefend = 100;
                        }
                    }
                    catch (Throwable e) {
                        if (defaultConfig != null) {
                            if (eInfo.classType != null && defaultConfig.entityInfoMap.containsKey(eInfo.classType.getName())) {
                                eInfo.decisionDefend = defaultConfig.entityInfoMap.get((Object)eInfo.classType.getName()).decisionDefend;
                                this.logEntityInvalidValue("decision_defend_probability", name, String.valueOf(eInfo.decisionDefend));
                                nestedConf.set("decision_defend_probability", (Object)eInfo.decisionDefend);
                            } else if (!eInfo.customName.isEmpty() && defaultConfig.customEntityInfoMap.containsKey(eInfo.customName)) {
                                eInfo.decisionDefend = defaultConfig.customEntityInfoMap.get((Object)eInfo.customName).decisionDefend;
                                this.logEntityInvalidValue("decision_defend_probability", name, String.valueOf(eInfo.decisionDefend));
                                nestedConf.set("decision_defend_probability", (Object)eInfo.decisionDefend);
                            } else {
                                this.logEntityInvalidValue("decision_defend_probability", name, "20");
                                eInfo.decisionDefend = 20;
                                nestedConf.set("decision_defend_probability", (Object)eInfo.decisionDefend);
                            }
                        }
                        this.logEntityInvalidValue("decision_defend_probability", name, "20");
                        eInfo.decisionDefend = 20;
                    }
                    try {
                        eInfo.decisionFlee = nestedConf.getInt("decision_flee_probability");
                        if (eInfo.decisionFlee < 0) {
                            this.logClampedValueEntity("decision_flee_probability", name, Integer.toString(eInfo.decisionFlee), "0");
                            eInfo.decisionFlee = 0;
                        } else if (eInfo.decisionFlee > 100) {
                            this.logClampedValueEntity("decision_flee_probability", name, Integer.toString(eInfo.decisionFlee), "100");
                            eInfo.decisionFlee = 100;
                        }
                    }
                    catch (Throwable e) {
                        if (defaultConfig != null) {
                            if (eInfo.classType != null && defaultConfig.entityInfoMap.containsKey(eInfo.classType.getName())) {
                                eInfo.decisionFlee = defaultConfig.entityInfoMap.get((Object)eInfo.classType.getName()).decisionFlee;
                                this.logEntityInvalidValue("decision_flee_probability", name, String.valueOf(eInfo.decisionFlee));
                                nestedConf.set("decision_flee_probability", (Object)eInfo.decisionFlee);
                            } else if (!eInfo.customName.isEmpty() && defaultConfig.customEntityInfoMap.containsKey(eInfo.customName)) {
                                eInfo.decisionFlee = defaultConfig.customEntityInfoMap.get((Object)eInfo.customName).decisionFlee;
                                this.logEntityInvalidValue("decision_flee_probability", name, String.valueOf(eInfo.decisionFlee));
                                nestedConf.set("decision_flee_probability", (Object)eInfo.decisionFlee);
                            } else {
                                this.logEntityInvalidValue("decision_flee_probability", name, "10");
                                eInfo.decisionFlee = 10;
                                nestedConf.set("decision_flee_probability", (Object)eInfo.decisionFlee);
                            }
                        }
                        this.logEntityInvalidValue("decision_flee_probability", name, "10");
                        eInfo.decisionFlee = 10;
                    }
                }
                if (eInfo.classType != null) {
                    this.entityInfoMap.put(eInfo.classType.getName(), eInfo);
                    continue;
                }
                if (!eInfo.customName.isEmpty()) {
                    this.customEntityInfoMap.put(eInfo.customName, eInfo);
                    continue;
                }
                if (!eInfo.playerName.isEmpty()) {
                    this.customPlayerInfoMap.put(eInfo.playerName, eInfo);
                    continue;
                }
                this.logger.error("Cannot add entity to internal config, no \"name\" or \"custom_name\" or \"player_name\"");
            }
            if (defaultConfig != null) {
                CommentedConfig newConf;
                for (String key : defaultConfig.entityInfoMap.keySet()) {
                    if (this.entityInfoMap.containsKey(key)) continue;
                    eInfo = defaultConfig.entityInfoMap.get(key);
                    this.entityInfoMap.put(key, eInfo);
                    newConf = conf.createSubConfig();
                    newConf.set("name", (Object)eInfo.classType.getName());
                    newConf.set("attack_power", (Object)eInfo.attackPower);
                    newConf.set("attack_probability", (Object)eInfo.attackProbability);
                    newConf.set("attack_variance", (Object)eInfo.attackVariance);
                    newConf.set("attack_effect", (Object)eInfo.attackEffect);
                    newConf.set("attack_effect_probability", (Object)eInfo.attackEffectProbability);
                    newConf.set("defense_damage", (Object)eInfo.defenseDamage);
                    newConf.set("defense_damage_probability", (Object)eInfo.defenseDamageProbability);
                    newConf.set("evasion", (Object)eInfo.evasion);
                    newConf.set("speed", (Object)eInfo.speed);
                    newConf.set("haste_speed", (Object)eInfo.hasteSpeed);
                    newConf.set("slow_speed", (Object)eInfo.slowSpeed);
                    newConf.set("ignore_battle", (Object)eInfo.ignoreBattle);
                    newConf.set("category", (Object)eInfo.category);
                    newConf.set("decision_attack_probability", (Object)eInfo.decisionAttack);
                    newConf.set("decision_defend_probability", (Object)eInfo.decisionDefend);
                    newConf.set("decision_flee_probability", (Object)eInfo.decisionFlee);
                    entities.add(newConf);
                    this.logEntityNotFound(key);
                }
                for (String key : defaultConfig.customEntityInfoMap.keySet()) {
                    if (this.customEntityInfoMap.containsKey(key)) continue;
                    eInfo = defaultConfig.customEntityInfoMap.get(key);
                    this.customEntityInfoMap.put(key, eInfo);
                    newConf = conf.createSubConfig();
                    newConf.set("custom_name", (Object)eInfo.customName);
                    newConf.set("attack_power", (Object)eInfo.attackPower);
                    newConf.set("attack_probability", (Object)eInfo.attackProbability);
                    newConf.set("attack_variance", (Object)eInfo.attackVariance);
                    newConf.set("attack_effect", (Object)eInfo.attackEffect);
                    newConf.set("attack_effect_probability", (Object)eInfo.attackEffectProbability);
                    newConf.set("defense_damage", (Object)eInfo.defenseDamage);
                    newConf.set("defense_damage_probability", (Object)eInfo.defenseDamageProbability);
                    newConf.set("evasion", (Object)eInfo.evasion);
                    newConf.set("speed", (Object)eInfo.speed);
                    newConf.set("haste_speed", (Object)eInfo.hasteSpeed);
                    newConf.set("slow_speed", (Object)eInfo.slowSpeed);
                    newConf.set("ignore_battle", (Object)eInfo.ignoreBattle);
                    newConf.set("category", (Object)eInfo.category);
                    newConf.set("decision_attack_probability", (Object)eInfo.decisionAttack);
                    newConf.set("decision_defend_probability", (Object)eInfo.decisionDefend);
                    newConf.set("decision_flee_probability", (Object)eInfo.decisionFlee);
                    entities.add(newConf);
                    this.logCustomEntityNotFound(key);
                }
                for (String key : defaultConfig.customPlayerInfoMap.keySet()) {
                    if (this.customPlayerInfoMap.containsKey(key)) continue;
                    eInfo = defaultConfig.customPlayerInfoMap.get(key);
                    this.customPlayerInfoMap.put(key, eInfo);
                    newConf = conf.createSubConfig();
                    newConf.set("player_name", (Object)eInfo.playerName);
                    newConf.set("attack_probability", (Object)eInfo.attackProbability);
                    newConf.set("attack_effect", (Object)eInfo.attackEffect);
                    newConf.set("attack_effect_probability", (Object)eInfo.attackEffectProbability);
                    newConf.set("evasion", (Object)eInfo.evasion);
                    newConf.set("speed", (Object)eInfo.speed);
                    newConf.set("haste_speed", (Object)eInfo.hasteSpeed);
                    newConf.set("slow_speed", (Object)eInfo.slowSpeed);
                    entities.add(newConf);
                    this.logPlayerEntityNotFound(key);
                }
            }
        }
        if (defaultConfig != null) {
            conf.save();
            conf.close();
        }
        return true;
    }

    private void logNotFound(String option) {
        if (this.logger != null) {
            this.logger.warn("Config option \"" + option + "\" not found, setting defaults");
        }
    }

    private void logNotFound(String option, String defaultValue) {
        if (this.logger != null) {
            this.logger.warn("Config option \"" + option + "\" not found, defaulting to \"" + defaultValue + "\"");
        }
    }

    private void logEntityInvalidValue(String option, String name, String defaultValue) {
        if (this.logger != null) {
            this.logger.warn("Invalid \"" + option + "\" for \"" + name + "\", defaulting to \"" + defaultValue + "\"");
        }
    }

    private void logEntityMissingRequiredValue(String option, String name, String defaultValue) {
        if (this.logger != null) {
            this.logger.warn("Entity \"" + name + "\" does not have option \"" + option + "\", defaulting to \"" + defaultValue + "\"");
        }
    }

    private void logEntityMissingOptionalValue(String option, String name, String defaultValue) {
        if (this.logger != null) {
            this.logger.info("Entity \"" + name + "\" does not have optional option \"" + option + "\", defaulting to \"" + defaultValue + "\"...");
        }
    }

    private void logClampedValue(String option, String from, String clampedTo) {
        if (this.logger != null) {
            this.logger.warn("Option \"" + option + "\" is out of bounds, clamping value from \"" + from + "\" to \"" + clampedTo + "\"");
        }
    }

    private void logClampedValueEntity(String option, String name, String from, String clampedTo) {
        if (this.logger != null) {
            this.logger.warn("Option \"" + option + "\" is out of bounds for \"" + name + "\", clamping value from \"" + from + "\" to \"" + clampedTo + "\"");
        }
    }

    private void logTOMLInvalidValue(String option) {
        if (this.logger != null) {
            this.logger.warn("Config option \"" + option + "\" is an invalid value, setting defaults");
        }
    }

    private void logTOMLInvalidValue(String option, String defaultValue) {
        if (this.logger != null) {
            this.logger.warn("Config option \"" + option + "\" is an invalid value, defaulting to \"" + defaultValue + "\"");
        }
    }

    private void logEntityNotFound(String entityName) {
        if (this.logger != null) {
            this.logger.warn("Entity entry named \"" + entityName + "\" in default config, but not in this config, adding");
        }
    }

    private void logCustomEntityNotFound(String entityName) {
        if (this.logger != null) {
            this.logger.warn("Entity custom entry named \"" + entityName + "\" in default config, but not in this config, adding");
        }
    }

    private void logPlayerEntityNotFound(String entityName) {
        if (this.logger != null) {
            this.logger.warn("Entity player entry named \"" + entityName + "\" in default config, but not in this config, adding");
        }
    }

    private boolean addEntityEntry(EntityInfo eInfo) {
        Collection entities;
        CommentedFileConfig conf = (CommentedFileConfig)CommentedFileConfig.builder((String)"config/TurnBasedMinecraft/TBM_Config.toml").build();
        conf.load();
        try {
            entities = (Collection)conf.get("server_config.entity");
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        CommentedConfig newConf = conf.createSubConfig();
        if (eInfo.playerName.isEmpty()) {
            newConf.set("attack_power", (Object)eInfo.attackPower);
        }
        newConf.set("attack_probability", (Object)eInfo.attackProbability);
        if (eInfo.playerName.isEmpty()) {
            newConf.set("attack_variance", (Object)eInfo.attackVariance);
        }
        newConf.set("attack_effect", (Object)eInfo.attackEffect.toString());
        newConf.set("attack_effect_probability", (Object)eInfo.attackEffectProbability);
        if (eInfo.playerName.isEmpty()) {
            newConf.set("defense_damage", (Object)eInfo.defenseDamage);
            newConf.set("defense_damage_probability", (Object)eInfo.defenseDamageProbability);
        }
        newConf.set("evasion", (Object)eInfo.evasion);
        newConf.set("speed", (Object)eInfo.speed);
        newConf.set("haste_speed", (Object)eInfo.hasteSpeed);
        newConf.set("slow_speed", (Object)eInfo.slowSpeed);
        if (eInfo.playerName.isEmpty()) {
            newConf.set("ignore_battle", (Object)eInfo.ignoreBattle);
            newConf.set("category", (Object)eInfo.category);
            newConf.set("decision_attack_probability", (Object)eInfo.decisionAttack);
            newConf.set("decision_defend_probability", (Object)eInfo.decisionDefend);
            newConf.set("decision_flee_probability", (Object)eInfo.decisionFlee);
        }
        entities.add(newConf);
        conf.save();
        conf.close();
        return true;
    }

    protected boolean editEntityEntry(EntityInfo eInfo) {
        boolean saved;
        CommentedFileConfig conf;
        block26: {
            Collection entities;
            conf = (CommentedFileConfig)CommentedFileConfig.builder((String)"config/TurnBasedMinecraft/TBM_Config.toml").build();
            conf.load();
            try {
                entities = (Collection)conf.get("server_config.entity");
            }
            catch (Throwable t) {
                t.printStackTrace();
                return false;
            }
            saved = false;
            try {
                if (eInfo.classType != null || !eInfo.customName.isEmpty() || !eInfo.playerName.isEmpty()) {
                    for (com.electronwill.nightconfig.core.Config entity : entities) {
                        String entityName = (String)entity.get("name");
                        String customName = (String)entity.get("custom_name");
                        String playerName = (String)entity.get("player_name");
                        if (eInfo.classType != null && entityName != null && entityName.equals(eInfo.classType.getName())) {
                            entity.set("attack_power", (Object)eInfo.attackPower);
                            entity.set("attack_probability", (Object)eInfo.attackProbability);
                            entity.set("attack_variance", (Object)eInfo.attackVariance);
                            entity.set("attack_effect", (Object)eInfo.attackEffect.toString());
                            entity.set("attack_effect_probability", (Object)eInfo.attackEffectProbability);
                            entity.set("defense_damage", (Object)eInfo.defenseDamage);
                            entity.set("defense_damage_probability", (Object)eInfo.defenseDamageProbability);
                            entity.set("evasion", (Object)eInfo.evasion);
                            entity.set("speed", (Object)eInfo.speed);
                            entity.set("haste_speed", (Object)eInfo.hasteSpeed);
                            entity.set("slow_speed", (Object)eInfo.slowSpeed);
                            entity.set("ignore_battle", (Object)eInfo.ignoreBattle);
                            entity.set("category", (Object)eInfo.category);
                            entity.set("decision_attack_probability", (Object)eInfo.decisionAttack);
                            entity.set("decision_defend_probability", (Object)eInfo.decisionDefend);
                            entity.set("decision_flee_probability", (Object)eInfo.decisionFlee);
                            saved = true;
                            break;
                        }
                        if (!eInfo.customName.isEmpty() && customName != null && customName.equals(eInfo.customName)) {
                            entity.set("attack_power", (Object)eInfo.attackPower);
                            entity.set("attack_probability", (Object)eInfo.attackProbability);
                            entity.set("attack_variance", (Object)eInfo.attackVariance);
                            entity.set("attack_effect", (Object)eInfo.attackEffect.toString());
                            entity.set("attack_effect_probability", (Object)eInfo.attackEffectProbability);
                            entity.set("defense_damage", (Object)eInfo.defenseDamage);
                            entity.set("defense_damage_probability", (Object)eInfo.defenseDamageProbability);
                            entity.set("evasion", (Object)eInfo.evasion);
                            entity.set("speed", (Object)eInfo.speed);
                            entity.set("haste_speed", (Object)eInfo.hasteSpeed);
                            entity.set("slow_speed", (Object)eInfo.slowSpeed);
                            entity.set("ignore_battle", (Object)eInfo.ignoreBattle);
                            entity.set("category", (Object)eInfo.category);
                            entity.set("decision_attack_probability", (Object)eInfo.decisionAttack);
                            entity.set("decision_defend_probability", (Object)eInfo.decisionDefend);
                            entity.set("decision_flee_probability", (Object)eInfo.decisionFlee);
                            saved = true;
                            break;
                        }
                        if (eInfo.playerName.isEmpty() || playerName == null || !playerName.equals(eInfo.playerName)) continue;
                        entity.set("attack_probability", (Object)eInfo.attackProbability);
                        entity.set("attack_effect", (Object)eInfo.attackEffect.toString());
                        entity.set("attack_effect_probability", (Object)eInfo.attackEffectProbability);
                        entity.set("evasion", (Object)eInfo.evasion);
                        entity.set("speed", (Object)eInfo.speed);
                        entity.set("haste_speed", (Object)eInfo.hasteSpeed);
                        entity.set("slow_speed", (Object)eInfo.slowSpeed);
                        saved = true;
                        break;
                    }
                    if (!saved) {
                        CommentedConfig newEntry = conf.createSubConfig();
                        if (eInfo.classType != null) {
                            newEntry.set("name", (Object)eInfo.classType.getName());
                        } else if (!eInfo.customName.isEmpty()) {
                            newEntry.set("custom_name", (Object)eInfo.customName);
                        } else if (!eInfo.playerName.isEmpty()) {
                            newEntry.set("player_name", (Object)eInfo.playerName);
                        } else {
                            this.logger.error("Failed to save new entity entry into config, no name or custom_name");
                            conf.close();
                            return false;
                        }
                        if (eInfo.playerName.isEmpty()) {
                            newEntry.set("attack_power", (Object)eInfo.attackPower);
                        }
                        newEntry.set("attack_probability", (Object)eInfo.attackProbability);
                        if (eInfo.playerName.isEmpty()) {
                            newEntry.set("attack_variance", (Object)eInfo.attackVariance);
                        }
                        newEntry.set("attack_effect", (Object)eInfo.attackEffect.toString());
                        newEntry.set("attack_effect_probability", (Object)eInfo.attackEffectProbability);
                        if (eInfo.playerName.isEmpty()) {
                            newEntry.set("defense_damage", (Object)eInfo.defenseDamage);
                            newEntry.set("defense_damage_probability", (Object)eInfo.defenseDamageProbability);
                        }
                        newEntry.set("evasion", (Object)eInfo.evasion);
                        newEntry.set("speed", (Object)eInfo.speed);
                        newEntry.set("haste_speed", (Object)eInfo.hasteSpeed);
                        newEntry.set("slow_speed", (Object)eInfo.slowSpeed);
                        if (eInfo.playerName.isEmpty()) {
                            newEntry.set("ignore_battle", (Object)eInfo.ignoreBattle);
                            newEntry.set("category", (Object)eInfo.category);
                            newEntry.set("decision_attack_probability", (Object)eInfo.decisionAttack);
                            newEntry.set("decision_defend_probability", (Object)eInfo.decisionDefend);
                            newEntry.set("decision_flee_probability", (Object)eInfo.decisionFlee);
                        }
                        entities.add(newEntry);
                        saved = true;
                    }
                    break block26;
                }
                return false;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
        }
        conf.save();
        conf.close();
        if (!saved) {
            this.logger.warn("Failed to save \"" + eInfo.classType.getName() + "\"");
            return false;
        }
        if (eInfo.classType != null) {
            this.entityInfoMap.put(eInfo.classType.getName(), eInfo);
        } else if (!eInfo.customName.isEmpty()) {
            this.customEntityInfoMap.put(eInfo.customName, eInfo);
        } else if (!eInfo.playerName.isEmpty()) {
            this.customPlayerInfoMap.put(eInfo.playerName, eInfo);
        } else {
            this.logger.warn("Failed to update entity info in memory");
        }
        return true;
    }

    public int getPlayerSpeed() {
        return this.playerSpeed;
    }

    public void setPlayerSpeed(int speed) {
        if (speed < 0) {
            speed = 0;
        } else if (speed > 100) {
            speed = 100;
        }
        this.playerSpeed = speed;
    }

    public int getPlayerHasteSpeed() {
        return this.playerHasteSpeed;
    }

    public void setPlayerHasteSpeed(int speed) {
        if (speed < 0) {
            speed = 0;
        } else if (speed > 100) {
            speed = 100;
        }
        this.playerHasteSpeed = speed;
    }

    public int getPlayerSlowSpeed() {
        return this.playerSlowSpeed;
    }

    public void setPlayerSlowSpeed(int speed) {
        if (speed < 0) {
            speed = 0;
        } else if (speed > 100) {
            speed = 100;
        }
        this.playerSlowSpeed = speed;
    }

    public int getPlayerAttackProbability() {
        return this.playerAttackProbability;
    }

    public void setPlayerAttackProbability(int probability) {
        if (probability < 1) {
            probability = 1;
        } else if (probability > 100) {
            probability = 100;
        }
        this.playerAttackProbability = probability;
    }

    public int getPlayerEvasion() {
        return this.playerEvasion;
    }

    public void setPlayerEvasion(int evasion) {
        if (evasion < 0) {
            evasion = 0;
        } else if (evasion > 100) {
            evasion = 100;
        }
        this.playerEvasion = evasion;
    }

    public int getDefenseDuration() {
        return this.defenseDuration;
    }

    public void setDefenseDuration(int turns) {
        if (turns < 0) {
            turns = 0;
        } else if (turns > 5) {
            turns = 5;
        }
        this.defenseDuration = turns;
    }

    public int getFleeGoodProbability() {
        return this.fleeGoodProbability;
    }

    public void setFleeGoodProbability(int probability) {
        if (probability < 1) {
            probability = 1;
        } else if (probability > 100) {
            probability = 100;
        }
        this.fleeGoodProbability = probability;
    }

    public int getFleeBadProbability() {
        return this.fleeBadProbability;
    }

    public void setFleeBadProbability(int probability) {
        if (probability < 1) {
            probability = 1;
        } else if (probability > 100) {
            probability = 100;
        }
        this.fleeBadProbability = probability;
    }

    public EntityInfo getEntityInfo(String classFullName) {
        if (classFullName == null) {
            return null;
        }
        EntityInfo eInfo = this.entityInfoMap.get(classFullName);
        if (eInfo != null) {
            eInfo = eInfo.clone();
        }
        return eInfo;
    }

    protected EntityInfo getEntityInfoReference(String classFullName) {
        if (classFullName == null) {
            return null;
        }
        return this.entityInfoMap.get(classFullName);
    }

    protected EntityInfo getMatchingEntityInfo(Object entity) {
        if (entity == null) {
            return null;
        }
        EntityInfo matching = this.entityInfoMap.get(entity.getClass().getName());
        if (matching != null && matching.classType.isInstance(entity)) {
            return matching;
        }
        return null;
    }

    public EntityInfo getCustomEntityInfo(String customName) {
        if (customName == null) {
            return null;
        }
        EntityInfo eInfo = this.customEntityInfoMap.get(customName);
        if (eInfo != null) {
            eInfo = eInfo.clone();
        }
        return eInfo;
    }

    public EntityInfo getPlayerInfo(String playerName) {
        if (playerName == null) {
            return null;
        }
        EntityInfo eInfo = this.customPlayerInfoMap.get(playerName);
        if (eInfo != null) {
            eInfo = eInfo.clone();
        }
        return eInfo;
    }

    protected EntityInfo getCustomEntityInfoReference(String customName) {
        if (customName == null) {
            return null;
        }
        return this.customEntityInfoMap.get(customName);
    }

    protected EntityInfo getPlayerInfoReference(String playerName) {
        if (playerName == null) {
            return null;
        }
        return this.customPlayerInfoMap.get(playerName);
    }

    private int getConfigFileVersion(File configFile) {
        int version = 0;
        FileConfig conf = FileConfig.of((File)configFile, (ConfigFormat)TomlFormat.instance());
        conf.load();
        version = conf.getIntOrElse("version", 0);
        conf.close();
        return version;
    }

    private void writeDefaultConfig(InputStream io) {
        try {
            int count;
            FileOutputStream fos = new FileOutputStream("config/TurnBasedMinecraft/TBM_Config_DEFAULT.toml");
            byte[] buffer = new byte[1024];
            while ((count = io.read(buffer)) > 0) {
                fos.write(buffer, 0, count);
            }
            fos.close();
            io.close();
        }
        catch (Throwable e) {
            this.logger.error("Failed to write default config", e);
        }
    }

    private boolean getCanOverwrite(File configFile) {
        FileConfig conf = FileConfig.of((File)configFile, (ConfigFormat)TomlFormat.instance());
        conf.load();
        boolean canOverwrite = (Boolean)conf.getOrElse("do_not_overwrite", (Object)false) == false;
        conf.close();
        return canOverwrite;
    }

    private CommentedFileConfig getConfigObj(File configFile) {
        CommentedFileConfig conf = (CommentedFileConfig)CommentedFileConfig.builder((File)configFile).defaultResource("config/TurnBasedMinecraft/TBM_Config_DEFAULT.toml").build();
        conf.load();
        return conf;
    }

    public boolean updateConfig(String path, Object value) {
        File configFile = new File("config/TurnBasedMinecraft/TBM_Config.toml");
        CommentedFileConfig conf = this.getConfigObj(configFile);
        conf.set(path, value);
        conf.save();
        conf.close();
        return true;
    }

    public boolean updateConfigAppendToStringArray(String path, String string_value) {
        Collection strings;
        File configFile = new File("config/TurnBasedMinecraft/TBM_Config.toml");
        CommentedFileConfig conf = this.getConfigObj(configFile);
        try {
            strings = (Collection)conf.get(path);
        }
        catch (Exception e) {
            TurnBasedMinecraftMod.logger.warn("Exception during fetching Collection<String> from config (append)");
            TurnBasedMinecraftMod.logger.warn((Object)e);
            return false;
        }
        if (strings.contains(string_value)) {
            return false;
        }
        strings.add(string_value);
        try {
            conf.set(path, (Object)strings);
        }
        catch (Exception e) {
            TurnBasedMinecraftMod.logger.warn("Exception during setting Collection<String> in config (append)");
            TurnBasedMinecraftMod.logger.warn((Object)e);
            return false;
        }
        conf.save();
        conf.close();
        return true;
    }

    public boolean updateConfigRemoveFromStringArray(String path, String string_value) {
        Collection strings;
        File configFile = new File("config/TurnBasedMinecraft/TBM_Config.toml");
        CommentedFileConfig conf = this.getConfigObj(configFile);
        try {
            strings = (Collection)conf.get(path);
        }
        catch (Exception e) {
            TurnBasedMinecraftMod.logger.warn("Exception during fetching Collection<String> from config (removal)");
            TurnBasedMinecraftMod.logger.warn((Object)e);
            return false;
        }
        if (!strings.contains(string_value)) {
            return false;
        }
        strings.remove(string_value);
        try {
            conf.set(path, (Object)strings);
        }
        catch (Exception e) {
            TurnBasedMinecraftMod.logger.warn("Exception during setting Collection<String> in config (removal)");
            TurnBasedMinecraftMod.logger.warn((Object)e);
            return false;
        }
        conf.save();
        conf.close();
        return true;
    }

    public boolean isIgnoreBattleType(String type) {
        return this.ignoreBattleTypes.contains(type);
    }

    public Collection<String> getIgnoreBattleTypes() {
        return this.ignoreBattleTypes;
    }

    public boolean removeIgnoreBattleType(String category) {
        return this.ignoreBattleTypes.remove(category);
    }

    public boolean addIgnoreBattleType(String category) {
        return this.ignoreBattleTypes.add(category);
    }

    public int getMinimumHitPercentage() {
        return this.minimumHitPercentage;
    }

    public void setMinimumHitPercentage(int percentage) {
        if (percentage < 1) {
            percentage = 1;
        } else if (percentage > 100) {
            percentage = 100;
        }
        this.minimumHitPercentage = percentage;
    }

    public int getMaxInBattle() {
        return this.maxInBattle;
    }

    public void setMaxInBattle(int maxInBattle) {
        if (maxInBattle < 2) {
            maxInBattle = 2;
        } else if (maxInBattle > 30) {
            maxInBattle = 30;
        }
        this.maxInBattle = maxInBattle;
    }

    public boolean isFreezeCombatantsEnabled() {
        return this.freezeCombatantsInBattle;
    }

    public void setFreezeCombatantsInBattle(boolean enabled) {
        this.freezeCombatantsInBattle = enabled;
    }

    public int getConfigVersion() {
        return this.configVersion;
    }

    public long getDecisionDurationNanos() {
        return this.battleDecisionDurationNanos;
    }

    public int getDecisionDurationSeconds() {
        return (int)(this.battleDecisionDurationNanos / 1000000000L);
    }

    public void setDecisionDurationSeconds(long seconds) {
        if (seconds < 5L) {
            seconds = 5L;
        } else if (seconds > 60L) {
            seconds = 60L;
        }
        this.battleDecisionDurationNanos = seconds * 1000000000L;
    }

    protected void addBattleIgnoringPlayer(int id) {
        this.battleIgnoringPlayers.add(id);
    }

    protected void removeBattleIgnoringPlayer(int id) {
        this.battleIgnoringPlayers.remove(id);
    }

    protected void clearBattleIgnoringPlayers() {
        this.battleIgnoringPlayers.clear();
    }

    protected Set<Integer> getBattleIgnoringPlayers() {
        return this.battleIgnoringPlayers;
    }

    public boolean getIfOnlyOPsCanDisableTurnBasedForSelf() {
        return this.onlyOPsSelfDisableTB;
    }

    public void setIfOnlyOPsCanDisableTurnBasedForSelf(boolean enabled_for_only_ops) {
        this.onlyOPsSelfDisableTB = enabled_for_only_ops;
    }

    protected void setBattleDisabledForAll(boolean isDisabled) {
        this.battleDisabledForAll = isDisabled;
    }

    protected boolean getBattleDisabledForAll() {
        return this.battleDisabledForAll;
    }

    public boolean isOldBattleBehaviorEnabled() {
        return this.oldBattleBehaviorEnabled;
    }

    public void setOldBattleBehavior(boolean enabled) {
        this.oldBattleBehaviorEnabled = enabled;
    }

    public int getLeaveBattleCooldownSeconds() {
        return this.leaveBattleCooldownSeconds;
    }

    public void setLeaveBattleCooldownSeconds(int seconds) {
        if (seconds < 1) {
            seconds = 1;
        } else if (seconds > 10) {
            seconds = 10;
        }
        this.leaveBattleCooldownSeconds = seconds;
    }

    public long getLeaveBattleCooldownNanos() {
        return (long)this.leaveBattleCooldownSeconds * 1000000000L;
    }

    public int getAggroStartBattleDistance() {
        return this.aggroStartBattleDistance;
    }

    public void setAggroStartBattleDistance(int distance) {
        if (distance < 5) {
            distance = 5;
        } else if (distance > 50) {
            distance = 50;
        }
        this.aggroStartBattleDistance = distance;
    }

    public int getCreeperExplodeTurn() {
        return this.creeperExplodeTurn;
    }

    public void setCreeperExplodeTurn(int turns) {
        if (turns < 1) {
            turns = 1;
        } else if (turns > 10) {
            turns = 10;
        }
        this.creeperExplodeTurn = turns;
    }

    public boolean getCreeperStopExplodeOnLeaveBattle() {
        return this.creeperStopExplodeOnLeaveBattle;
    }

    public void setCreeperStopExplodeOnLeaveBattle(boolean stop_explode_on_leave_battle) {
        this.creeperStopExplodeOnLeaveBattle = stop_explode_on_leave_battle;
    }

    public boolean getCreeperAlwaysAllowDamage() {
        return this.creeperAlwaysAllowDamage;
    }

    public void setCreeperAlwaysAllowDamage(boolean allow_damage) {
        this.creeperAlwaysAllowDamage = allow_damage;
    }

    public boolean isBattleDecisionDurationForever() {
        return this.battleDecisionDurationForever;
    }

    public void setBattleDecisionDurationForever(boolean battleDecisionDurationForever) {
        this.battleDecisionDurationForever = battleDecisionDurationForever;
    }

    public final Collection<String> getPossibleIgnoreHurtDamageSources() {
        return this.possibleIgnoreHurtDamageSources;
    }

    public final Collection<String> getIgnoreHurtDamageSources() {
        return this.ignoreHurtDamageSources;
    }

    public boolean addIgnoreHurtDamageSource(String source) {
        if (this.possibleIgnoreHurtDamageSources.contains(source) && !this.ignoreHurtDamageSources.contains(source)) {
            this.ignoreHurtDamageSources.add(source);
            return true;
        }
        return false;
    }

    public boolean removeIgnoreHurtDamageSource(String source) {
        return this.ignoreHurtDamageSources.remove(source);
    }

    public boolean isPlayerOnlyBattlesEnabled() {
        return this.playerOnlyBattles;
    }

    public void setIsPlayerOnlyBattles(boolean enabled) {
        this.playerOnlyBattles = enabled;
    }

    private void loadDamageSources() {
        this.possibleIgnoreHurtDamageSources.clear();
        try {
            VanillaRegistries.createLookup().lookupOrThrow(Registries.DAMAGE_TYPE).listElements().forEach(dt -> this.possibleIgnoreHurtDamageSources.add(((DamageType)dt.get()).msgId()));
        }
        catch (Exception e) {
            this.logger.warn("Config failed to load possible DamageSources! Undesired things may happen, like Zombies dying from Fire during battle!");
            this.logger.warn((Object)e);
        }
    }

    public void verifyEntityNames() {
        this.logger.info("Begin verifying Entity names for TurnBasedMC");
        File configFile = new File("config/TurnBasedMinecraft/TBM_Config.toml");
        if (!configFile.exists()) {
            this.logger.error("ERROR: TBM_Config.toml not found when verifying!");
            this.logger.info("End verifying Entity names for TurnBasedMC with ERROR.");
            return;
        }
        CommentedFileConfig conf = this.getConfigObj(configFile);
        Collection entities = (Collection)conf.get("server_config.entity");
        if (entities == null) {
            this.logger.error("ERROR: TBM_Config.toml does not have [[server_config.entity]] options!");
            this.logger.info("End verifying Entity names for TurnBasedMC with ERROR.");
            return;
        }
        for (com.electronwill.nightconfig.core.Config nestedConf : entities) {
            if (!nestedConf.contains("name")) continue;
            try {
                Class<?> clazz = Class.forName((String)nestedConf.get("name"));
            }
            catch (ClassNotFoundException e) {
                this.logger.warn("WARNING: name \"{}\" from [[server_config.entity]] does not exist!", (Object)nestedConf.get("name").toString());
            }
        }
        conf.close();
        this.logger.info("End verifying Entity names for TurnBasedMC.");
    }
}

