/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common;

import com.burnedkirby.TurnBasedMinecraft.common.AttackerViaBow;
import com.burnedkirby.TurnBasedMinecraft.common.Battle;
import com.burnedkirby.TurnBasedMinecraft.common.BattleManager;
import com.burnedkirby.TurnBasedMinecraft.common.CommonProxy;
import com.burnedkirby.TurnBasedMinecraft.common.Config;
import com.burnedkirby.TurnBasedMinecraft.common.EditingInfo;
import com.burnedkirby.TurnBasedMinecraft.common.EntityInfo;
import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import com.burnedkirby.TurnBasedMinecraft.common.Utility;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleMessage;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketEditingMessage;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketGeneralMessage;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Creeper;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class AttackEventHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAttackerValid(LivingIncomingDamageEvent event) {
        if (event.getSource().getEntity() == null) {
            return false;
        }
        if (event.getSource().getEntity().equals((Object)TurnBasedMinecraftMod.proxy.getAttackingEntity())) {
            return true;
        }
        long now = System.nanoTime();
        boolean isValid = false;
        Set<AttackerViaBow> set = TurnBasedMinecraftMod.proxy.getAttackerViaBowSet();
        synchronized (set) {
            Iterator<AttackerViaBow> iter = TurnBasedMinecraftMod.proxy.getAttackerViaBowSet().iterator();
            while (iter.hasNext()) {
                AttackerViaBow attacker = iter.next();
                if (now - attacker.attackTime >= AttackerViaBow.ATTACK_TIMEOUT) {
                    iter.remove();
                    continue;
                }
                if (!event.getSource().getEntity().equals((Object)attacker.entity) || !event.getSource().is(DamageTypes.ARROW)) continue;
                iter.remove();
                if (isValid) continue;
                Battle b = TurnBasedMinecraftMod.proxy.getBattleManager().getBattleByID(attacker.battleID);
                if (b != null) {
                    b.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ARROW_HIT, attacker.entity.getId(), event.getEntity().getId(), 0);
                }
                isValid = true;
            }
        }
        return isValid;
    }

    @SubscribeEvent
    public void entityAttacked(LivingIncomingDamageEvent event) {
        EditingInfo editingInfo;
        if (event.getEntity().level().isClientSide) {
            return;
        }
        CommonProxy proxy = TurnBasedMinecraftMod.proxy;
        Config config = proxy.getConfig();
        BattleManager battleManager = proxy.getBattleManager();
        if (event.getSource().getEntity() != null && event.getEntity() != null && (editingInfo = proxy.getEditingInfo(event.getSource().getEntity().getId())) != null && editingInfo.isPendingEntitySelection) {
            editingInfo.isPendingEntitySelection = false;
            event.setCanceled(true);
            if (editingInfo.isEditingCustomName) {
                if (!event.getEntity().hasCustomName()) {
                    TurnBasedMinecraftMod.logger.error("Cannot edit custom name from entity without custom name");
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)editingInfo.editor), (CustomPacketPayload)new PacketGeneralMessage("Cannot edit custom name from entity without custom name"), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    return;
                }
                editingInfo.entityInfo = config.getCustomEntityInfo(event.getEntity().getCustomName().getString());
                if (editingInfo.entityInfo == null) {
                    editingInfo.entityInfo = new EntityInfo();
                    editingInfo.entityInfo.customName = event.getEntity().getCustomName().getString();
                }
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)editingInfo.editor), (CustomPacketPayload)new PacketGeneralMessage("Editing custom name \"" + event.getEntity().getCustomName().getString() + "\""), (CustomPacketPayload[])new CustomPacketPayload[0]);
                TurnBasedMinecraftMod.logger.info("Begin editing custom \"" + event.getEntity().getCustomName().getString() + "\"");
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)editingInfo.editor), (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                editingInfo.entityInfo = config.getMatchingEntityInfo(event.getEntity());
                if (editingInfo.entityInfo == null) {
                    editingInfo.entityInfo = new EntityInfo();
                    editingInfo.entityInfo.classType = event.getEntity().getClass();
                } else {
                    editingInfo.entityInfo = editingInfo.entityInfo.clone();
                }
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)editingInfo.editor), (CustomPacketPayload)new PacketGeneralMessage("Editing entity \"" + editingInfo.entityInfo.classType.getName() + "\""), (CustomPacketPayload[])new CustomPacketPayload[0]);
                TurnBasedMinecraftMod.logger.info("Begin editing \"" + editingInfo.entityInfo.classType.getName() + "\"");
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)editingInfo.editor), (CustomPacketPayload)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return;
        }
        if (event.getEntity() != null && event.getSource().getEntity() != null && (battleManager.isRecentlyLeftBattle(event.getEntity().getId()) || battleManager.isRecentlyLeftBattle(event.getSource().getEntity().getId()))) {
            if (event.getSource().getEntity() instanceof Creeper && TurnBasedMinecraftMod.proxy.getConfig().getCreeperAlwaysAllowDamage()) {
                event.setCanceled(false);
            } else {
                event.setCanceled(true);
            }
            return;
        }
        if (!this.isAttackerValid(event) && event.getEntity() != null && event.getSource().getEntity() != null && event.getEntity() != event.getSource().getEntity() && !config.getBattleIgnoringPlayers().contains(event.getSource().getEntity().getId()) && !config.getBattleIgnoringPlayers().contains(event.getEntity().getId()) && event.getEntity().level().dimension().equals(event.getSource().getEntity().level().dimension()) && battleManager.checkAttack(event)) {
            event.setCanceled(true);
        }
        if (TurnBasedMinecraftMod.proxy.getAttackingDamage() < (int)event.getAmount()) {
            TurnBasedMinecraftMod.proxy.setAttackingDamage((int)event.getAmount());
        }
    }

    @SubscribeEvent
    public void entityTargeted(LivingChangeTargetEvent event) {
        Config config = TurnBasedMinecraftMod.proxy.getConfig();
        BattleManager battleManager = TurnBasedMinecraftMod.proxy.getBattleManager();
        if (event.getEntity().level().isClientSide || config.isOldBattleBehaviorEnabled() || event.getEntity() != null && battleManager.isRecentlyLeftBattle(event.getEntity().getId()) || event.getNewAboutToBeSetTarget() != null && battleManager.isRecentlyLeftBattle(event.getNewAboutToBeSetTarget().getId()) || event.getEntity() != null && event.getNewAboutToBeSetTarget() != null && Utility.distanceBetweenEntities((Entity)event.getEntity(), (Entity)event.getNewAboutToBeSetTarget()) > (double)config.getAggroStartBattleDistance()) {
            return;
        }
        if (event.getEntity() != null && event.getNewAboutToBeSetTarget() != null && !config.getBattleIgnoringPlayers().contains(event.getEntity().getId()) && !config.getBattleIgnoringPlayers().contains(event.getNewAboutToBeSetTarget().getId()) && event.getEntity().level().dimension().equals(event.getNewAboutToBeSetTarget().level().dimension())) {
            TurnBasedMinecraftMod.proxy.getBattleManager().checkTargeted(event);
        }
    }
}

