/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common;

import com.burnedkirby.TurnBasedMinecraft.common.AttackerViaBow;
import com.burnedkirby.TurnBasedMinecraft.common.BattleManager;
import com.burnedkirby.TurnBasedMinecraft.common.Combatant;
import com.burnedkirby.TurnBasedMinecraft.common.EntityIDDimPair;
import com.burnedkirby.TurnBasedMinecraft.common.EntityInfo;
import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import com.burnedkirby.TurnBasedMinecraft.common.Utility;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleInfo;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleMessage;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattlePing;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.CreativeModeTabRegistry;
import net.neoforged.neoforge.network.PacketDistributor;

public class Battle {
    private final int id;
    private Map<Integer, Combatant> sideA;
    private Map<Integer, Combatant> sideB;
    private Map<Integer, Combatant> players;
    private PriorityQueue<Combatant> turnOrderQueue;
    private Queue<Combatant> sideAEntryQueue;
    private Queue<Combatant> sideBEntryQueue;
    private State state;
    private AtomicInteger playerCount;
    private AtomicInteger undecidedCount;
    private long lastInstant;
    private long timer;
    private boolean timerForever;
    private boolean isServer;
    private boolean battleEnded;
    private BattleManager battleManager;
    private Random random;
    public String debugLog;
    private ResourceKey<Level> dimension;
    private long pingTimerNanos;

    public Battle(BattleManager battleManager, int id, Collection<Entity> sideA, Collection<Entity> sideB, boolean isServer, ResourceKey<Level> dimension) {
        Combatant newCombatant;
        EntityInfo entityInfo;
        this.battleManager = battleManager;
        this.isServer = isServer;
        this.id = id;
        this.sideA = new ConcurrentHashMap<Integer, Combatant>();
        this.sideB = new ConcurrentHashMap<Integer, Combatant>();
        this.players = new ConcurrentHashMap<Integer, Combatant>();
        this.turnOrderQueue = new PriorityQueue<Combatant>(new Combatant.CombatantComparator());
        this.sideAEntryQueue = new ArrayDeque<Combatant>();
        this.sideBEntryQueue = new ArrayDeque<Combatant>();
        this.playerCount = new AtomicInteger(0);
        this.undecidedCount = new AtomicInteger(0);
        this.random = new Random();
        this.dimension = dimension;
        this.pingTimerNanos = 0L;
        if (sideA != null) {
            for (Entity e : sideA) {
                try {
                    entityInfo = TurnBasedMinecraftMod.proxy.getConfig().getCustomEntityInfoReference(e.getCustomName().getString());
                }
                catch (NullPointerException exception) {
                    entityInfo = null;
                }
                if (entityInfo == null) {
                    entityInfo = TurnBasedMinecraftMod.proxy.getConfig().getPlayerInfo(e.getName().getString());
                }
                if (entityInfo == null) {
                    entityInfo = TurnBasedMinecraftMod.proxy.getConfig().getMatchingEntityInfo(e);
                }
                if (entityInfo == null && !(e instanceof Player) && TurnBasedMinecraftMod.proxy.isServerRunning()) continue;
                newCombatant = new Combatant(e, entityInfo);
                newCombatant.isSideA = true;
                newCombatant.battleID = this.getId();
                this.sideA.put(e.getId(), newCombatant);
                if (e instanceof Player) {
                    newCombatant.recalcSpeedOnCompare = true;
                    this.playerCount.incrementAndGet();
                    this.players.put(e.getId(), newCombatant);
                }
                if (!TurnBasedMinecraftMod.proxy.getConfig().isFreezeCombatantsEnabled()) continue;
                newCombatant.x = e.getX();
                newCombatant.z = e.getZ();
                newCombatant.yaw = e.getXRot();
                newCombatant.pitch = e.getYRot();
            }
        }
        if (sideB != null) {
            for (Entity e : sideB) {
                try {
                    entityInfo = TurnBasedMinecraftMod.proxy.getConfig().getCustomEntityInfoReference(e.getCustomName().getString());
                }
                catch (NullPointerException exception) {
                    entityInfo = null;
                }
                if (entityInfo == null) {
                    entityInfo = TurnBasedMinecraftMod.proxy.getConfig().getPlayerInfo(e.getName().getString());
                }
                if (entityInfo == null) {
                    entityInfo = TurnBasedMinecraftMod.proxy.getConfig().getMatchingEntityInfo(e);
                }
                if (entityInfo == null && !(e instanceof Player) && TurnBasedMinecraftMod.proxy.isServerRunning()) continue;
                newCombatant = new Combatant(e, entityInfo);
                newCombatant.isSideA = false;
                newCombatant.battleID = this.getId();
                this.sideB.put(e.getId(), newCombatant);
                if (e instanceof Player) {
                    newCombatant.recalcSpeedOnCompare = true;
                    this.playerCount.incrementAndGet();
                    this.players.put(e.getId(), newCombatant);
                }
                if (!TurnBasedMinecraftMod.proxy.getConfig().isFreezeCombatantsEnabled()) continue;
                newCombatant.x = e.getX();
                newCombatant.z = e.getZ();
                newCombatant.yaw = e.getXRot();
                newCombatant.pitch = e.getYRot();
            }
        }
        if (isServer) {
            for (Combatant c : this.sideA.values()) {
                if (c.entityInfo != null) {
                    this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, c.entity.getId(), 0, id, c.entityInfo.category);
                    continue;
                }
                if (c.entity instanceof Player) {
                    this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, c.entity.getId(), 0, id, "player");
                    continue;
                }
                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, c.entity.getId(), 0, id);
            }
            for (Combatant c : this.sideB.values()) {
                if (c.entityInfo != null) {
                    this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, c.entity.getId(), 0, id, c.entityInfo.category);
                    continue;
                }
                if (c.entity instanceof Player) {
                    this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, c.entity.getId(), 0, id, "player");
                    continue;
                }
                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, c.entity.getId(), 0, id);
            }
        }
        this.lastInstant = System.nanoTime();
        this.state = State.DECISION;
        this.undecidedCount.set(this.playerCount.get());
        this.timer = TurnBasedMinecraftMod.proxy.getConfig().getDecisionDurationNanos();
        this.timerForever = TurnBasedMinecraftMod.proxy.getConfig().isBattleDecisionDurationForever();
        this.battleEnded = false;
        this.notifyPlayersBattleInfo();
    }

    public int getId() {
        return this.id;
    }

    public Entity getCombatantEntity(int entityID) {
        Combatant c = this.sideA.get(entityID);
        if (c != null) {
            return c.entity;
        }
        c = this.sideB.get(entityID);
        if (c != null) {
            return c.entity;
        }
        return null;
    }

    public boolean hasCombatant(int entityID) {
        for (Combatant c : this.sideAEntryQueue) {
            if (c.entity.getId() != entityID) continue;
            return true;
        }
        for (Combatant c : this.sideBEntryQueue) {
            if (c.entity.getId() != entityID) continue;
            return true;
        }
        return this.sideA.containsKey(entityID) || this.sideB.containsKey(entityID);
    }

    public boolean hasCombatantInSideA(int entityID) {
        for (Combatant c : this.sideAEntryQueue) {
            if (c.entity.getId() != entityID) continue;
            return true;
        }
        return this.sideA.containsKey(entityID);
    }

    public void addCombatantToSideA(Entity e) {
        EntityInfo entityInfo;
        try {
            entityInfo = TurnBasedMinecraftMod.proxy.getConfig().getCustomEntityInfoReference(e.getCustomName().getString());
        }
        catch (NullPointerException exception) {
            entityInfo = null;
        }
        if (entityInfo == null) {
            entityInfo = TurnBasedMinecraftMod.proxy.getConfig().getPlayerInfo(e.getName().getString());
        }
        if (entityInfo == null) {
            entityInfo = TurnBasedMinecraftMod.proxy.getConfig().getMatchingEntityInfo(e);
        }
        if (this.isServer && entityInfo == null && !(e instanceof Player) && TurnBasedMinecraftMod.proxy.isServerRunning()) {
            return;
        }
        Combatant newCombatant = new Combatant(e, entityInfo);
        newCombatant.isSideA = true;
        newCombatant.battleID = this.getId();
        if (this.isServer) {
            this.sideAEntryQueue.add(newCombatant);
        } else {
            this.sideA.put(e.getId(), newCombatant);
        }
        if (e instanceof Player) {
            newCombatant.recalcSpeedOnCompare = true;
            this.playerCount.incrementAndGet();
            this.players.put(e.getId(), newCombatant);
            if (this.state == State.DECISION) {
                this.undecidedCount.incrementAndGet();
            }
        }
        if (TurnBasedMinecraftMod.proxy.getConfig().isFreezeCombatantsEnabled()) {
            newCombatant.x = e.getX();
            newCombatant.z = e.getZ();
            newCombatant.yaw = e.getXRot();
            newCombatant.pitch = e.getYRot();
        }
        if (this.isServer) {
            if (newCombatant.entityInfo != null) {
                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, newCombatant.entity.getId(), 0, this.id, newCombatant.entityInfo.category);
            } else if (newCombatant.entity instanceof Player) {
                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, newCombatant.entity.getId(), 0, this.id, "player");
            } else {
                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, newCombatant.entity.getId(), 0, this.id);
            }
        }
        this.notifyPlayersBattleInfo();
    }

    public void addCombatantToSideB(Entity e) {
        EntityInfo entityInfo;
        try {
            entityInfo = TurnBasedMinecraftMod.proxy.getConfig().getCustomEntityInfoReference(e.getCustomName().getString());
        }
        catch (NullPointerException exception) {
            entityInfo = null;
        }
        if (entityInfo == null) {
            entityInfo = TurnBasedMinecraftMod.proxy.getConfig().getPlayerInfo(e.getName().getString());
        }
        if (entityInfo == null) {
            entityInfo = TurnBasedMinecraftMod.proxy.getConfig().getMatchingEntityInfo(e);
        }
        if (this.isServer && entityInfo == null && !(e instanceof Player) && TurnBasedMinecraftMod.proxy.isServerRunning()) {
            return;
        }
        Combatant newCombatant = new Combatant(e, entityInfo);
        newCombatant.isSideA = false;
        newCombatant.battleID = this.getId();
        if (this.isServer) {
            this.sideBEntryQueue.add(newCombatant);
        } else {
            this.sideB.put(e.getId(), newCombatant);
        }
        if (e instanceof Player) {
            newCombatant.recalcSpeedOnCompare = true;
            this.playerCount.incrementAndGet();
            this.players.put(e.getId(), newCombatant);
            if (this.state == State.DECISION) {
                this.undecidedCount.incrementAndGet();
            }
        }
        if (TurnBasedMinecraftMod.proxy.getConfig().isFreezeCombatantsEnabled()) {
            newCombatant.x = e.getX();
            newCombatant.z = e.getZ();
            newCombatant.yaw = e.getXRot();
            newCombatant.pitch = e.getYRot();
        }
        if (this.isServer) {
            if (newCombatant.entityInfo != null) {
                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, newCombatant.entity.getId(), 0, this.id, newCombatant.entityInfo.category);
            } else if (newCombatant.entity instanceof Player) {
                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, newCombatant.entity.getId(), 0, this.id, "player");
            } else {
                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, newCombatant.entity.getId(), 0, this.id);
            }
        }
        this.notifyPlayersBattleInfo();
    }

    public void clearCombatants() {
        this.sideA.clear();
        this.sideB.clear();
        this.sideAEntryQueue.clear();
        this.sideBEntryQueue.clear();
        this.players.clear();
        this.playerCount.set(0);
        this.undecidedCount.set(0);
    }

    public Collection<Combatant> getSideA() {
        return this.sideA.values();
    }

    public Collection<Combatant> getSideB() {
        return this.sideB.values();
    }

    public Set<Map.Entry<Integer, Combatant>> getSideAEntrySet() {
        return this.sideA.entrySet();
    }

    public Set<Map.Entry<Integer, Combatant>> getSideBEntrySet() {
        return this.sideB.entrySet();
    }

    public Collection<Integer> getSideAIDs() {
        ArrayList<Integer> sideAIDs = new ArrayList<Integer>(this.sideA.size());
        for (Combatant combatant : this.sideA.values()) {
            sideAIDs.add(combatant.entity.getId());
        }
        return sideAIDs;
    }

    public Collection<Integer> getSideBIDs() {
        ArrayList<Integer> sideBIDs = new ArrayList<Integer>(this.sideB.size());
        for (Combatant combatant : this.sideB.values()) {
            sideBIDs.add(combatant.entity.getId());
        }
        return sideBIDs;
    }

    public Combatant getCombatantByID(int entityID) {
        Combatant combatant = this.sideA.get(entityID);
        if (combatant == null) {
            combatant = this.sideB.get(entityID);
        }
        return combatant;
    }

    public void setDecision(int entityID, Decision decision, int targetIDOrItemID) {
        if (this.state != State.DECISION) {
            return;
        }
        Combatant combatant = this.players.get(entityID);
        if (combatant == null || combatant.decision != Decision.UNDECIDED) {
            return;
        }
        combatant.decision = decision;
        if (decision == Decision.ATTACK) {
            combatant.targetEntityID = targetIDOrItemID;
        } else if (decision == Decision.USE_ITEM || decision == Decision.SWITCH_ITEM) {
            combatant.itemToUse = targetIDOrItemID;
        }
        this.undecidedCount.decrementAndGet();
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public long getTimerSeconds() {
        return this.timer / 1000000000L;
    }

    public long getTimerNanos() {
        return this.timer;
    }

    public int getSize() {
        int size = this.sideA.size() + this.sideB.size();
        size += this.sideAEntryQueue.size();
        return size += this.sideBEntryQueue.size();
    }

    protected void notifyPlayersBattleInfo() {
        if (!this.isServer) {
            return;
        }
        PacketBattleInfo infoPacket = new PacketBattleInfo(this.getId(), this.getSideAIDs(), this.getSideBIDs(), this.timer, TurnBasedMinecraftMod.proxy.getConfig().getDecisionDurationNanos(), !TurnBasedMinecraftMod.proxy.getConfig().isBattleDecisionDurationForever());
        for (Combatant p : this.players.values()) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)p.entity), (CustomPacketPayload)infoPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    protected void notifyPlayersBattlePing() {
        if (!this.isServer) {
            return;
        }
        PacketBattlePing pingPacket = new PacketBattlePing(this.getId(), (int)(this.timer / 1000000000L));
        for (Combatant p : this.players.values()) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)p.entity), (CustomPacketPayload)pingPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    protected void sendMessageToAllPlayers(PacketBattleMessage.MessageType type, int from, int to, int amount) {
        this.sendMessageToAllPlayers(type, from, to, amount, new String());
    }

    protected void sendMessageToAllPlayers(PacketBattleMessage.MessageType type, int from, int to, int amount, String custom) {
        if (!this.isServer) {
            return;
        }
        PacketBattleMessage packet = new PacketBattleMessage(type, from, to, this.dimension, amount, custom);
        for (Combatant p : this.players.values()) {
            if (!p.entity.isAlive()) continue;
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)p.entity), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private boolean healthCheck() {
        String category;
        Map.Entry<Integer, Combatant> entry;
        boolean didRemove = false;
        Iterator<Map.Entry<Integer, Combatant>> iter = this.sideA.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            if (entry.getValue().entity.isAlive()) continue;
            iter.remove();
            this.players.remove(entry.getKey());
            this.removeCombatantPostRemove(entry.getValue());
            didRemove = true;
            category = null;
            if (entry.getValue().entityInfo != null) {
                category = entry.getValue().entityInfo.category;
            } else if (entry.getValue().entity instanceof Player) {
                category = "player";
            }
            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.DIED, entry.getValue().entity.getId(), 0, 0, category);
        }
        iter = this.sideB.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            if (entry.getValue().entity.isAlive()) continue;
            iter.remove();
            this.players.remove(entry.getKey());
            this.removeCombatantPostRemove(entry.getValue());
            didRemove = true;
            category = null;
            if (entry.getValue().entityInfo != null) {
                category = entry.getValue().entityInfo.category;
            } else if (entry.getValue().entity instanceof Player) {
                category = "player";
            }
            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.DIED, entry.getValue().entity.getId(), 0, 0, category);
        }
        if (this.players.isEmpty() || this.sideA.isEmpty() || this.sideB.isEmpty()) {
            this.battleEnded = true;
        } else if (didRemove) {
            this.resetUndecidedCount();
        }
        return didRemove;
    }

    private boolean isCreativeCheck() {
        boolean didRemove = false;
        Iterator<Map.Entry<Integer, Combatant>> iter = this.players.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, Combatant> entry = iter.next();
            if (entry.getValue().entity == null || !((Player)entry.getValue().entity).isCreative()) continue;
            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.BECAME_CREATIVE, entry.getValue().entity.getId(), 0, 0);
            iter.remove();
            this.sideA.remove(entry.getKey());
            this.sideB.remove(entry.getKey());
            this.playerCount.decrementAndGet();
            this.removeCombatantPostRemove(entry.getValue());
            didRemove = true;
        }
        if (didRemove) {
            this.resetUndecidedCount();
        }
        return didRemove;
    }

    private void resetUndecidedCount() {
        if (this.state == State.DECISION) {
            this.undecidedCount.set(0);
            for (Combatant p : this.players.values()) {
                if (p.decision != Decision.UNDECIDED) continue;
                this.undecidedCount.incrementAndGet();
            }
        }
    }

    private void enforceFreezePositions() {
        for (Combatant c : this.sideA.values()) {
            c.entity.setPos(c.x, c.entity.getY(), c.z);
            c.entity.setYBodyRot(c.yaw);
            c.entity.setYHeadRot(c.pitch);
        }
        for (Combatant c : this.sideB.values()) {
            c.entity.setPos(c.x, c.entity.getY(), c.z);
            c.entity.setYBodyRot(c.yaw);
            c.entity.setYHeadRot(c.pitch);
        }
    }

    private void removeCombatant(Combatant c) {
        this.sideA.remove(c.entity.getId());
        this.sideB.remove(c.entity.getId());
        if (this.players.remove(c.entity.getId()) != null) {
            this.playerCount.decrementAndGet();
        }
        this.removeCombatantPostRemove(c);
    }

    private void removeCombatantPostRemove(Combatant c) {
        if (c.entity instanceof Player) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)c.entity), (CustomPacketPayload)new PacketBattleMessage(PacketBattleMessage.MessageType.ENDED, 0, 0, this.dimension, 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.battleManager.addRecentlyLeftBattle(c);
    }

    public void forceRemoveCombatant(EntityIDDimPair e) {
        Combatant c;
        this.sideA.remove(e.id);
        this.sideB.remove(e.id);
        if (this.players.remove(e.id) != null) {
            this.playerCount.decrementAndGet();
        }
        Iterator iter = this.sideAEntryQueue.iterator();
        while (iter.hasNext()) {
            c = (Combatant)iter.next();
            if (c.entity.getId() != e.id) continue;
            iter.remove();
            break;
        }
        iter = this.sideBEntryQueue.iterator();
        while (iter.hasNext()) {
            c = (Combatant)iter.next();
            if (c.entity.getId() != e.id) continue;
            iter.remove();
            break;
        }
    }

    private void setDecisionState() {
        for (Combatant c : this.sideA.values()) {
            c.decision = Decision.UNDECIDED;
        }
        for (Combatant c : this.sideB.values()) {
            c.decision = Decision.UNDECIDED;
        }
        this.state = State.DECISION;
        this.undecidedCount.set(this.players.size());
    }

    public boolean update() {
        if (!this.isServer) {
            return false;
        }
        if (this.battleEnded) {
            ArrayList<Combatant> combatants = new ArrayList<Combatant>();
            combatants.addAll(this.sideA.values());
            combatants.addAll(this.sideB.values());
            for (Combatant c : combatants) {
                this.removeCombatant(c);
            }
            return true;
        }
        long nextInstant = System.nanoTime();
        long dt = nextInstant - this.lastInstant;
        this.lastInstant = nextInstant;
        try {
            return this.update(dt);
        }
        catch (Throwable t) {
            TurnBasedMinecraftMod.logger.error("Update: ", t);
            this.setDecisionState();
            boolean changed = false;
            if (this.healthCheck()) {
                changed = true;
            }
            if (this.isCreativeCheck()) {
                changed = true;
            }
            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.TURN_END, 0, 0, 1);
            if (changed) {
                this.notifyPlayersBattleInfo();
            }
            return this.battleEnded;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean update(long dt) {
        this.pingTimerNanos += dt;
        if (this.pingTimerNanos >= 4000000000L) {
            this.pingTimerNanos = 0L;
            this.notifyPlayersBattlePing();
        }
        if (this.battleEnded) {
            combatants = new ArrayList<Combatant>();
            combatants.addAll(this.sideA.values());
            combatants.addAll(this.sideB.values());
            for (Combatant c : combatants) {
                this.removeCombatant(c);
            }
            return true;
        }
        combatantsChanged = false;
        c = this.sideAEntryQueue.poll();
        while (c != null) {
            this.sideA.put(c.entity.getId(), (Combatant)c);
            combatantsChanged = true;
            c = this.sideAEntryQueue.poll();
        }
        c = this.sideBEntryQueue.poll();
        while (c != null) {
            this.sideB.put(c.entity.getId(), (Combatant)c);
            combatantsChanged = true;
            c = this.sideBEntryQueue.poll();
        }
        if (TurnBasedMinecraftMod.proxy.getConfig().isFreezeCombatantsEnabled()) {
            this.enforceFreezePositions();
        }
        this.defuseCreepers();
        switch (this.state.ordinal()) {
            case 0: {
                this.timer -= dt;
                if (!this.timerForever && this.timer <= 0L || this.undecidedCount.get() <= 0) {
                    for (Combatant c : this.sideA.values()) {
                        if (c.entity instanceof Player || c.decision != Decision.UNDECIDED || c.entityInfo == null) continue;
                        if (c.entity instanceof Creeper) {
                            if (c.creeperTurns++ < TurnBasedMinecraftMod.proxy.getConfig().getCreeperExplodeTurn()) {
                                c.decision = Decision.CREEPER_WAIT;
                                continue;
                            }
                            c.decision = Decision.CREEPER_EXPLODE;
                            continue;
                        }
                        percentage = this.random.nextInt(100);
                        if (percentage < c.entityInfo.decisionAttack) {
                            c.decision = Decision.ATTACK;
                            continue;
                        }
                        if (percentage - c.entityInfo.decisionAttack < c.entityInfo.decisionDefend) {
                            c.decision = Decision.DEFEND;
                            continue;
                        }
                        if (percentage - c.entityInfo.decisionAttack - c.entityInfo.decisionDefend >= c.entityInfo.decisionFlee) continue;
                        c.decision = Decision.FLEE;
                    }
                    for (Combatant c : this.sideB.values()) {
                        if (c.entity instanceof Player || c.decision != Decision.UNDECIDED || c.entityInfo == null) continue;
                        if (c.entity instanceof Creeper) {
                            if (c.creeperTurns++ < TurnBasedMinecraftMod.proxy.getConfig().getCreeperExplodeTurn()) {
                                c.decision = Decision.CREEPER_WAIT;
                                continue;
                            }
                            c.decision = Decision.CREEPER_EXPLODE;
                            continue;
                        }
                        percentage = this.random.nextInt(100);
                        if (percentage < c.entityInfo.decisionAttack) {
                            c.decision = Decision.ATTACK;
                            continue;
                        }
                        if (percentage - c.entityInfo.decisionAttack < c.entityInfo.decisionDefend) {
                            c.decision = Decision.DEFEND;
                            continue;
                        }
                        if (percentage - c.entityInfo.decisionAttack - c.entityInfo.decisionDefend >= c.entityInfo.decisionFlee) continue;
                        c.decision = Decision.FLEE;
                    }
                    this.state = State.ACTION;
                    this.timer = TurnBasedMinecraftMod.proxy.getConfig().getDecisionDurationNanos();
                    this.timerForever = TurnBasedMinecraftMod.proxy.getConfig().isBattleDecisionDurationForever();
                    this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.TURN_BEGIN, 0, 0, 0);
                    this.turnOrderQueue.clear();
                    for (Combatant c : this.sideA.values()) {
                        this.turnOrderQueue.add(c);
                    }
                    for (Combatant c : this.sideB.values()) {
                        this.turnOrderQueue.add(c);
                    }
                    return this.update(0L);
                }
                if (this.healthCheck()) {
                    combatantsChanged = true;
                }
                if (!this.isCreativeCheck()) break;
                combatantsChanged = true;
                break;
            }
            case 1: {
                next = this.turnOrderQueue.poll();
                if (next == null || !next.entity.isAlive()) ** GOTO lbl493
                this.debugLog = next.entity.getDisplayName().getString();
                next.remainingDefenses = 0;
                decision = next.decision;
                next.decision = Decision.UNDECIDED;
                switch (decision.ordinal()) {
                    case 0: {
                        this.debugLog = this.debugLog + " undecided";
                        this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.DID_NOTHING, next.entity.getId(), 0, 0);
                        break;
                    }
                    case 1: {
                        this.debugLog = this.debugLog + " attack";
                        target = null;
                        var8_11 = next.entity;
                        if (var8_11 instanceof Player) {
                            player = (Player)var8_11;
                            this.debugLog = this.debugLog + " as player";
                            target = this.sideA.get(next.targetEntityID);
                            if (target == null) {
                                target = this.sideB.get(next.targetEntityID);
                            }
                            if (target == null || !target.entity.isAlive() || target == next) break;
                            heldItemStack = player.getMainHandItem();
                            if (heldItemStack.getItem() instanceof BowItem) {
                                this.debugLog = this.debugLog + " with bow";
                                if (Utility.doesPlayerHaveArrows(player)) {
                                    nextEntity = next.entity;
                                    targetEntity = target.entity;
                                    yawDirection = Utility.yawDirection(next.entity.getX(), next.entity.getZ(), target.entity.getX(), target.entity.getZ());
                                    pitchDirection = Utility.pitchDirection(next.entity.getX(), next.entity.getY(), next.entity.getZ(), target.entity.getX(), target.entity.getY(), target.entity.getZ());
                                    randomTimeLeft = this.random.nextInt(heldItemStack.getItem().getUseDuration(heldItemStack, (LivingEntity)player) / 3);
                                    if (TurnBasedMinecraftMod.proxy.getConfig().isFreezeCombatantsEnabled()) {
                                        next.yaw = yawDirection;
                                        next.pitch = pitchDirection;
                                    }
                                    ((ServerPlayer)nextEntity).connection.teleport(nextEntity.getX(), nextEntity.getY(), nextEntity.getZ(), yawDirection, pitchDirection);
                                    itemBow = (BowItem)heldItemStack.getItem();
                                    TurnBasedMinecraftMod.proxy.getAttackerViaBowSet().add(new AttackerViaBow(nextEntity, this.getId()));
                                    itemBow.releaseUsing(((Player)nextEntity).getMainHandItem(), nextEntity.level(), (LivingEntity)nextEntity, randomTimeLeft);
                                    this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.FIRED_ARROW, nextEntity.getId(), targetEntity.getId(), 0);
                                    break;
                                }
                                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.BOW_NO_AMMO, next.entity.getId(), 0, 0);
                                break;
                            }
                            if (heldItemStack.getItem() instanceof CrossbowItem) {
                                this.debugLog = this.debugLog + " with crossbow";
                                if (Utility.doesPlayerHaveArrows(player)) {
                                    nextEntity = next.entity;
                                    targetEntity = target.entity;
                                    yawDirection = Utility.yawDirection(next.entity.getX(), next.entity.getZ(), target.entity.getX(), target.entity.getZ());
                                    pitchDirection = Utility.pitchDirection(next.entity.getX(), next.entity.getY(), next.entity.getZ(), target.entity.getX(), target.entity.getY(), target.entity.getZ());
                                    if (TurnBasedMinecraftMod.proxy.getConfig().isFreezeCombatantsEnabled()) {
                                        next.yaw = yawDirection;
                                        next.pitch = pitchDirection;
                                    }
                                    ((ServerPlayer)nextEntity).connection.teleport(nextEntity.getX(), nextEntity.getY(), nextEntity.getZ(), yawDirection, pitchDirection);
                                    itemCrossbow = (CrossbowItem)heldItemStack.getItem();
                                    TurnBasedMinecraftMod.proxy.getAttackerViaBowSet().add(new AttackerViaBow(nextEntity, this.getId()));
                                    itemCrossbow.releaseUsing(heldItemStack, nextEntity.level(), (LivingEntity)nextEntity, -100);
                                    itemCrossbow.use(nextEntity.level(), (Player)nextEntity, InteractionHand.MAIN_HAND);
                                    this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.FIRED_ARROW, nextEntity.getId(), targetEntity.getId(), 0);
                                    break;
                                }
                                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.CROSSBOW_NO_AMMO, next.entity.getId(), 0, 0);
                                break;
                            }
                            this.debugLog = this.debugLog + " without bow";
                            hitChance = next.entityInfo != null && next.entityInfo.playerName.isEmpty() == false ? next.entityInfo.attackProbability : TurnBasedMinecraftMod.proxy.getConfig().getPlayerAttackProbability();
                            hitChance = target.entity instanceof Player ? (target.entityInfo != null && !target.entityInfo.playerName.isEmpty() ? hitChance * (100 - target.entityInfo.evasion) / 100 : hitChance * (100 - TurnBasedMinecraftMod.proxy.getConfig().getPlayerEvasion()) / 100) : hitChance * (100 - target.entityInfo.evasion) / 100;
                            if (hitChance < TurnBasedMinecraftMod.proxy.getConfig().getMinimumHitPercentage()) {
                                hitChance = TurnBasedMinecraftMod.proxy.getConfig().getMinimumHitPercentage();
                            }
                            if (this.random.nextInt(100) < hitChance) {
                                if (target.remainingDefenses <= 0) {
                                    this.debugLog = this.debugLog + " hit success";
                                    nextEntity = next.entity;
                                    targetEntity = target.entity;
                                    targetEntityInfo = target.entityInfo;
                                    yawDirection = Utility.yawDirection(next.entity.getX(), next.entity.getZ(), target.entity.getX(), target.entity.getZ());
                                    pitchDirection = Utility.pitchDirection(next.entity.getX(), next.entity.getY(), next.entity.getZ(), target.entity.getX(), target.entity.getY(), target.entity.getZ());
                                    defenseDamageTriggered = !(targetEntity instanceof Player) && targetEntityInfo.defenseDamage > 0 && targetEntityInfo.defenseDamageProbability > 0 ? this.random.nextInt(100) < targetEntityInfo.defenseDamageProbability : false;
                                    if (TurnBasedMinecraftMod.proxy.getConfig().isFreezeCombatantsEnabled()) {
                                        next.yaw = yawDirection;
                                        next.pitch = pitchDirection;
                                    }
                                    ((ServerPlayer)nextEntity).connection.teleport(nextEntity.getX(), nextEntity.getY(), nextEntity.getZ(), yawDirection, pitchDirection);
                                    TurnBasedMinecraftMod.proxy.setAttackingEntity(nextEntity);
                                    TurnBasedMinecraftMod.proxy.setAttackingDamage(0);
                                    ((Player)nextEntity).attack(targetEntity);
                                    TurnBasedMinecraftMod.proxy.setAttackingEntity(null);
                                    this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ATTACK, nextEntity.getId(), targetEntity.getId(), TurnBasedMinecraftMod.proxy.getAttackingDamage());
                                    if (next.entityInfo != null && next.entityInfo.attackEffect != EntityInfo.Effect.UNKNOWN && next.entityInfo.attackEffectProbability > 0 && this.random.nextInt(100) < next.entityInfo.attackEffectProbability) {
                                        next.entityInfo.attackEffect.applyEffectToEntity((LivingEntity)targetEntity);
                                        this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.WAS_AFFECTED, nextEntity.getId(), targetEntity.getId(), 0, next.entityInfo.attackEffect.getAffectedString());
                                    }
                                    if (!defenseDamageTriggered) break;
                                    defenseDamageSource = targetEntity.damageSources().mobAttack((LivingEntity)targetEntity);
                                    TurnBasedMinecraftMod.proxy.setAttackingEntity(targetEntity);
                                    nextEntity.invulnerableTime = 0;
                                    nextEntity.hurtServer((ServerLevel)nextEntity.level(), defenseDamageSource, (float)targetEntityInfo.defenseDamage);
                                    TurnBasedMinecraftMod.proxy.setAttackingEntity(null);
                                    this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.DEFENSE_DAMAGE, targetEntity.getId(), nextEntity.getId(), targetEntityInfo.defenseDamage);
                                    break;
                                }
                                this.debugLog = this.debugLog + " hit blocked";
                                --target.remainingDefenses;
                                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.DEFEND, target.entity.getId(), next.entity.getId(), 0);
                                break;
                            }
                            this.debugLog = this.debugLog + " hit missed";
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.MISS, next.entity.getId(), target.entity.getId(), 0);
                            break;
                        }
                        this.debugLog = this.debugLog + " as mob";
                        attackTarget = ((Mob)next.entity).getTarget();
                        if (attackTarget == null || !this.hasCombatant(attackTarget.getId())) ** GOTO lbl207
                        this.debugLog = this.debugLog + " to targeted";
                        target = this.getCombatantByID(attackTarget.getId());
                        ** GOTO lbl223
lbl207:
                        // 1 sources

                        this.debugLog = this.debugLog + " to random other side";
                        if (!next.isSideA) ** GOTO lbl217
                        if (this.sideB.size() <= 0) ** GOTO lbl223
                        randomTargetIndex = this.random.nextInt(this.sideB.size());
                        for (Combatant c : this.sideB.values()) {
                            if (randomTargetIndex-- != 0) continue;
                            target = c;
                            ** GOTO lbl223
                        }
                        ** GOTO lbl223
lbl217:
                        // 1 sources

                        if (this.sideA.size() > 0) {
                            randomTargetIndex = this.random.nextInt(this.sideA.size());
                            for (Combatant c : this.sideA.values()) {
                                if (randomTargetIndex-- != 0) continue;
                                target = c;
                                break;
                            }
                        }
lbl223:
                        // 8 sources

                        if (target == null || !target.entity.isAlive() || target == next) break;
                        hitChance = next.entityInfo.attackProbability;
                        hitChance = target.entity instanceof Player != false ? hitChance * (100 - TurnBasedMinecraftMod.proxy.getConfig().getPlayerEvasion()) / 100 : hitChance * (100 - target.entityInfo.evasion) / 100;
                        if (hitChance < TurnBasedMinecraftMod.proxy.getConfig().getMinimumHitPercentage()) {
                            hitChance = TurnBasedMinecraftMod.proxy.getConfig().getMinimumHitPercentage();
                        }
                        if (this.random.nextInt(100) < hitChance) {
                            if (target.remainingDefenses <= 0) {
                                this.debugLog = this.debugLog + " hit success";
                                damageSource = next.entity.damageSources().mobAttack((LivingEntity)next.entity);
                                damageAmount = next.entityInfo.attackPower;
                                if (next.entityInfo.attackVariance > 0) {
                                    damageAmount += this.random.nextInt(next.entityInfo.attackVariance * 2 + 1) - next.entityInfo.attackVariance;
                                }
                                if (damageAmount < 0) {
                                    damageAmount = 0;
                                }
                                if ((modifiers = (ItemAttributeModifiers)(heldItem = ((Mob)next.entity).getMainHandItem()).getItem().components().get(DataComponents.ATTRIBUTE_MODIFIERS)) != null) {
                                    for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
                                        if (entry.attribute() != Attributes.ATTACK_DAMAGE || !entry.modifier().is(Item.BASE_ATTACK_DAMAGE_ID) || entry.slot() != EquipmentSlotGroup.MAINHAND) continue;
                                        damageAmount += (int)Math.round(entry.modifier().amount());
                                        break;
                                    }
                                }
                                nextEntity = next.entity;
                                nextEntityInfo = next.entityInfo;
                                targetEntity = target.entity;
                                targetEntityInfo = target.entityInfo;
                                finalDamageAmount = damageAmount;
                                defenseDamageTriggered = !(targetEntity instanceof Player) && targetEntityInfo.defenseDamage > 0 && targetEntityInfo.defenseDamageProbability > 0 ? this.random.nextInt(100) < targetEntityInfo.defenseDamageProbability : false;
                                attackEffectTriggered = nextEntityInfo.attackEffect != EntityInfo.Effect.UNKNOWN && nextEntityInfo.attackEffectProbability > 0 ? this.random.nextInt(100) < nextEntityInfo.attackEffectProbability : false;
                                TurnBasedMinecraftMod.proxy.setAttackingEntity(nextEntity);
                                targetEntity.invulnerableTime = 0;
                                targetEntity.hurtServer((ServerLevel)targetEntity.level(), damageSource, (float)finalDamageAmount);
                                TurnBasedMinecraftMod.proxy.setAttackingEntity(null);
                                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ATTACK, nextEntity.getId(), targetEntity.getId(), finalDamageAmount);
                                if (defenseDamageTriggered) {
                                    defenseDamageSource = targetEntity.damageSources().mobAttack((LivingEntity)targetEntity);
                                    TurnBasedMinecraftMod.proxy.setAttackingEntity(targetEntity);
                                    nextEntity.invulnerableTime = 0;
                                    nextEntity.hurtServer((ServerLevel)nextEntity.level(), defenseDamageSource, (float)targetEntityInfo.defenseDamage);
                                    TurnBasedMinecraftMod.proxy.setAttackingEntity(null);
                                    this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.DEFENSE_DAMAGE, targetEntity.getId(), nextEntity.getId(), targetEntityInfo.defenseDamage);
                                }
                                if (!attackEffectTriggered) break;
                                nextEntityInfo.attackEffect.applyEffectToEntity((LivingEntity)targetEntity);
                                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.WAS_AFFECTED, nextEntity.getId(), targetEntity.getId(), 0, nextEntityInfo.attackEffect.getAffectedString());
                                break;
                            }
                            this.debugLog = this.debugLog + " hit blocked";
                            --target.remainingDefenses;
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.DEFEND, target.entity.getId(), next.entity.getId(), 0);
                            break;
                        }
                        this.debugLog = this.debugLog + " hit missed";
                        this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.MISS, next.entity.getId(), target.entity.getId(), 0);
                        break;
                    }
                    case 2: {
                        this.debugLog = this.debugLog + " defend";
                        next.remainingDefenses = TurnBasedMinecraftMod.proxy.getConfig().getDefenseDuration();
                        this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.DEFENDING, next.entity.getId(), 0, 0);
                        break;
                    }
                    case 3: {
                        this.debugLog = this.debugLog + " flee";
                        fastestEnemySpeed = 0;
                        if (next.isSideA) {
                            for (Combatant c : this.sideB.values()) {
                                damageAmount = c.entity;
                                if (damageAmount instanceof Player) {
                                    player = (Player)damageAmount;
                                    playerSpeed = c.entityInfo != null && c.entityInfo.playerName.isEmpty() == false ? c.entityInfo.speed : TurnBasedMinecraftMod.proxy.getConfig().getPlayerSpeed();
                                    if (player.hasEffect(MobEffects.SPEED)) {
                                        playerSpeed = c.entityInfo != null && !c.entityInfo.playerName.isEmpty() ? c.entityInfo.hasteSpeed : TurnBasedMinecraftMod.proxy.getConfig().getPlayerHasteSpeed();
                                    } else if (player.hasEffect(MobEffects.SLOWNESS)) {
                                        playerSpeed = c.entityInfo != null && c.entityInfo.playerName.isEmpty() == false ? c.entityInfo.slowSpeed : TurnBasedMinecraftMod.proxy.getConfig().getPlayerSlowSpeed();
                                    }
                                    if (playerSpeed <= fastestEnemySpeed) continue;
                                    fastestEnemySpeed = TurnBasedMinecraftMod.proxy.getConfig().getPlayerSpeed();
                                    continue;
                                }
                                heldItem = c.entity;
                                if (heldItem instanceof LivingEntity) {
                                    livingEntity = (LivingEntity)heldItem;
                                    if (livingEntity.hasEffect(MobEffects.SPEED)) {
                                        if (c.entityInfo.hasteSpeed <= fastestEnemySpeed) continue;
                                        fastestEnemySpeed = c.entityInfo.hasteSpeed;
                                        continue;
                                    }
                                    if (livingEntity.hasEffect(MobEffects.SLOWNESS)) {
                                        if (c.entityInfo.slowSpeed <= fastestEnemySpeed) continue;
                                        fastestEnemySpeed = c.entityInfo.slowSpeed;
                                        continue;
                                    }
                                    if (c.entityInfo.speed <= fastestEnemySpeed) continue;
                                    fastestEnemySpeed = c.entityInfo.speed;
                                    continue;
                                }
                                if (c.entityInfo.speed <= fastestEnemySpeed) continue;
                                fastestEnemySpeed = c.entityInfo.speed;
                            }
                        } else {
                            for (Combatant c : this.sideA.values()) {
                                livingEntity = c.entity;
                                if (livingEntity instanceof Player) {
                                    player = (Player)livingEntity;
                                    playerSpeed = c.entityInfo != null && c.entityInfo.playerName.isEmpty() == false ? c.entityInfo.speed : TurnBasedMinecraftMod.proxy.getConfig().getPlayerSpeed();
                                    if (player.hasEffect(MobEffects.SPEED)) {
                                        playerSpeed = c.entityInfo != null && !c.entityInfo.playerName.isEmpty() ? c.entityInfo.hasteSpeed : TurnBasedMinecraftMod.proxy.getConfig().getPlayerHasteSpeed();
                                    } else if (player.hasEffect(MobEffects.SLOWNESS)) {
                                        playerSpeed = c.entityInfo != null && c.entityInfo.playerName.isEmpty() == false ? c.entityInfo.slowSpeed : TurnBasedMinecraftMod.proxy.getConfig().getPlayerSlowSpeed();
                                    }
                                    if (playerSpeed <= fastestEnemySpeed) continue;
                                    fastestEnemySpeed = TurnBasedMinecraftMod.proxy.getConfig().getPlayerSpeed();
                                    continue;
                                }
                                heldItem = c.entity;
                                if (heldItem instanceof LivingEntity) {
                                    livingEntity = (LivingEntity)heldItem;
                                    if (livingEntity.hasEffect(MobEffects.SPEED)) {
                                        if (c.entityInfo.hasteSpeed <= fastestEnemySpeed) continue;
                                        fastestEnemySpeed = c.entityInfo.hasteSpeed;
                                        continue;
                                    }
                                    if (livingEntity.hasEffect(MobEffects.SLOWNESS)) {
                                        if (c.entityInfo.slowSpeed <= fastestEnemySpeed) continue;
                                        fastestEnemySpeed = c.entityInfo.slowSpeed;
                                        continue;
                                    }
                                    if (c.entityInfo.speed <= fastestEnemySpeed) continue;
                                    fastestEnemySpeed = c.entityInfo.speed;
                                    continue;
                                }
                                if (c.entityInfo.speed <= fastestEnemySpeed) continue;
                                fastestEnemySpeed = c.entityInfo.speed;
                            }
                        }
                        fleeProbability = 0;
                        player = next.entity;
                        if (player instanceof Player) {
                            player = (Player)player;
                            playerSpeed = next.entityInfo != null && next.entityInfo.playerName.isEmpty() == false ? next.entityInfo.speed : TurnBasedMinecraftMod.proxy.getConfig().getPlayerSpeed();
                            if (player.hasEffect(MobEffects.SPEED)) {
                                playerSpeed = next.entityInfo != null && !next.entityInfo.playerName.isEmpty() ? next.entityInfo.hasteSpeed : TurnBasedMinecraftMod.proxy.getConfig().getPlayerHasteSpeed();
                            } else if (player.hasEffect(MobEffects.SLOWNESS)) {
                                playerSpeed = next.entityInfo != null && next.entityInfo.playerName.isEmpty() == false ? next.entityInfo.slowSpeed : TurnBasedMinecraftMod.proxy.getConfig().getPlayerSlowSpeed();
                            }
                            fleeProbability = fastestEnemySpeed >= playerSpeed ? TurnBasedMinecraftMod.proxy.getConfig().getFleeBadProbability() : TurnBasedMinecraftMod.proxy.getConfig().getFleeGoodProbability();
                        } else {
                            fleeProbability = fastestEnemySpeed >= next.entityInfo.speed ? TurnBasedMinecraftMod.proxy.getConfig().getFleeBadProbability() : TurnBasedMinecraftMod.proxy.getConfig().getFleeGoodProbability();
                        }
                        if (this.random.nextInt(100) < fleeProbability) {
                            this.debugLog = this.debugLog + " success";
                            combatantsChanged = true;
                            fleeingCategory = new String();
                            if (next.entityInfo != null) {
                                fleeingCategory = next.entityInfo.category;
                            } else if (next.entity instanceof Player) {
                                fleeingCategory = "player";
                            }
                            this.removeCombatant(next);
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.FLEE, next.entity.getId(), 0, 1, fleeingCategory);
                            break;
                        }
                        this.debugLog = this.debugLog + " fail";
                        this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.FLEE, next.entity.getId(), 0, 0);
                        break;
                    }
                    case 4: {
                        this.debugLog = this.debugLog + " use item";
                        if (next.itemToUse < 0 || next.itemToUse > 8) {
                            this.debugLog = this.debugLog + " invalid";
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.USED_ITEM, next.entity.getId(), 0, PacketBattleMessage.UsedItemAction.USED_INVALID.getValue());
                            break;
                        }
                        targetItemStack = ((Player)next.entity).getInventory().getItem(next.itemToUse);
                        targetItem = targetItemStack.getItem();
                        if (targetItem == null) {
                            this.debugLog = this.debugLog + " null";
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.USED_ITEM, next.entity.getId(), 0, PacketBattleMessage.UsedItemAction.USED_NOTHING.getValue());
                            break;
                        }
                        if (Utility.isItemEdible(targetItemStack, (LivingEntity)next.entity)) {
                            this.debugLog = this.debugLog + " food";
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.USED_ITEM, next.entity.getId(), 0, PacketBattleMessage.UsedItemAction.USED_FOOD.getValue(), targetItemStack.getDisplayName().getString());
                            nextEntity = next.entity;
                            nextItemToUse = next.itemToUse;
                            ((Player)nextEntity).getInventory().setItem(nextItemToUse, targetItem.finishUsingItem(targetItemStack, nextEntity.level(), (LivingEntity)nextEntity));
                            break;
                        }
                        foodAndDrinksTab = CreativeModeTabRegistry.getTab((ResourceLocation)CreativeModeTabs.FOOD_AND_DRINKS.location());
                        if (foodAndDrinksTab.contains(targetItemStack) && Utility.isItemEdible(targetItemStack, (LivingEntity)next.entity)) {
                            this.debugLog = this.debugLog + " food";
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.USED_ITEM, next.entity.getId(), 0, PacketBattleMessage.UsedItemAction.USED_FOOD.getValue(), targetItemStack.getDisplayName().getString());
                            nextEntity = next.entity;
                            nextItemToUse = next.itemToUse;
                            ((Player)nextEntity).getInventory().setItem(nextItemToUse, targetItem.finishUsingItem(targetItemStack, nextEntity.level(), (LivingEntity)nextEntity));
                            break;
                        }
                        if (targetItem instanceof PotionItem && !(targetItem instanceof ThrowablePotionItem)) {
                            this.debugLog = this.debugLog + " potion";
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.USED_ITEM, next.entity.getId(), 0, PacketBattleMessage.UsedItemAction.USED_POTION.getValue(), targetItemStack.getDisplayName().getString());
                            nextEntity = next.entity;
                            nextItemToUse = next.itemToUse;
                            ((Player)nextEntity).getInventory().setItem(nextItemToUse, targetItem.finishUsingItem(targetItemStack, nextEntity.level(), (LivingEntity)nextEntity));
                            break;
                        }
                        this.debugLog = this.debugLog + " non-consumable";
                        this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.USED_ITEM, next.entity.getId(), 0, PacketBattleMessage.UsedItemAction.USED_INVALID.getValue(), targetItemStack.getDisplayName().getString());
                        nextEntity = next.entity;
                        nextItemToUse = next.itemToUse;
                        prevItem = ((Player)nextEntity).getInventory().getSelectedSlot();
                        ((Player)nextEntity).getInventory().setSelectedSlot(nextItemToUse);
                        interactionResult = targetItem.use(nextEntity.level(), (Player)nextEntity, InteractionHand.MAIN_HAND);
                        if (interactionResult instanceof InteractionResult.Success && (transformed = (resultSuccess = (InteractionResult.Success)interactionResult).heldItemTransformedTo()) != null) {
                            ((Player)nextEntity).getInventory().setItem(nextItemToUse, transformed);
                        }
                        ((Player)nextEntity).getInventory().setSelectedSlot(prevItem);
                        break;
                    }
                    case 5: {
                        this.debugLog = this.debugLog + " switch item";
                        if (next.itemToUse < 0 || next.itemToUse > 8) {
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.SWITCHED_ITEM, next.entity.getId(), 0, 0);
                            break;
                        }
                        nextEntity = next.entity;
                        nextItemToUse = next.itemToUse;
                        ((Player)nextEntity).getInventory().setSelectedSlot(nextItemToUse);
                        this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.SWITCHED_ITEM, next.entity.getId(), 0, 1);
                        break;
                    }
                    case 6: {
                        this.debugLog = this.debugLog + " creeper wait";
                        if (next.creeperTurns < TurnBasedMinecraftMod.proxy.getConfig().getCreeperExplodeTurn()) {
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.CREEPER_WAIT, next.entity.getId(), 0, 0);
                            break;
                        }
                        this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.CREEPER_WAIT_FINAL, next.entity.getId(), 0, 0);
                        break;
                    }
                    case 7: {
                        this.debugLog = this.debugLog + " creeper explode";
                        this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.CREEPER_EXPLODE, next.entity.getId(), 0, 0);
                        nextEntity = next.entity;
                        nextEntityInfo = next.entityInfo;
                        for (Combatant c : this.sideA.values()) {
                            if (c.entity.getId() == next.entity.getId()) continue;
                            hitChance = next.entityInfo.attackProbability;
                            hitChance = c.entity instanceof Player != false ? hitChance * (100 - TurnBasedMinecraftMod.proxy.getConfig().getPlayerEvasion()) / 100 : hitChance * (100 - c.entityInfo.evasion) / 100;
                            if (hitChance < TurnBasedMinecraftMod.proxy.getConfig().getMinimumHitPercentage()) {
                                hitChance = TurnBasedMinecraftMod.proxy.getConfig().getMinimumHitPercentage();
                            }
                            if (this.random.nextInt(100) >= hitChance) continue;
                            targetEntity = c.entity;
                            targetEntityInfo = c.entityInfo;
                            damageAmount = nextEntityInfo.attackPower;
                            if (nextEntityInfo.attackVariance > 0) {
                                damageAmount += this.random.nextInt(nextEntityInfo.attackVariance * 2 + 1) - nextEntityInfo.attackVariance;
                            }
                            if (damageAmount < 0) {
                                damageAmount = 0;
                            }
                            finalDamageAmount = damageAmount;
                            attackEffectTriggered = nextEntityInfo.attackEffect != EntityInfo.Effect.UNKNOWN && nextEntityInfo.attackEffectProbability > 0 ? this.random.nextInt(100) < nextEntityInfo.attackEffectProbability : false;
                            TurnBasedMinecraftMod.proxy.setAttackingEntity(nextEntity);
                            targetEntity.invulnerableTime = 0;
                            targetEntity.hurtServer((ServerLevel)targetEntity.level(), nextEntity.damageSources().mobAttack((LivingEntity)nextEntity), (float)finalDamageAmount);
                            TurnBasedMinecraftMod.proxy.setAttackingEntity(null);
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ATTACK, nextEntity.getId(), targetEntity.getId(), finalDamageAmount);
                            if (!attackEffectTriggered) continue;
                            nextEntityInfo.attackEffect.applyEffectToEntity((LivingEntity)targetEntity);
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.WAS_AFFECTED, nextEntity.getId(), targetEntity.getId(), 0, nextEntityInfo.attackEffect.getAffectedString());
                        }
                        for (Combatant c : this.sideB.values()) {
                            if (c.entity.getId() == next.entity.getId()) continue;
                            hitChance = next.entityInfo.attackProbability;
                            hitChance = c.entity instanceof Player != false ? hitChance * (100 - TurnBasedMinecraftMod.proxy.getConfig().getPlayerEvasion()) / 100 : hitChance * (100 - c.entityInfo.evasion) / 100;
                            if (hitChance < TurnBasedMinecraftMod.proxy.getConfig().getMinimumHitPercentage()) {
                                hitChance = TurnBasedMinecraftMod.proxy.getConfig().getMinimumHitPercentage();
                            }
                            if (this.random.nextInt(100) >= hitChance) continue;
                            targetEntity = c.entity;
                            targetEntityInfo = c.entityInfo;
                            damageAmount = nextEntityInfo.attackPower;
                            if (nextEntityInfo.attackVariance > 0) {
                                damageAmount += this.random.nextInt(nextEntityInfo.attackVariance * 2 + 1) - nextEntityInfo.attackVariance;
                            }
                            if (damageAmount < 0) {
                                damageAmount = 0;
                            }
                            finalDamageAmount = damageAmount;
                            attackEffectTriggered = nextEntityInfo.attackEffect != EntityInfo.Effect.UNKNOWN && nextEntityInfo.attackEffectProbability > 0 ? this.random.nextInt(100) < nextEntityInfo.attackEffectProbability : false;
                            TurnBasedMinecraftMod.proxy.setAttackingEntity(nextEntity);
                            targetEntity.invulnerableTime = 0;
                            targetEntity.hurtServer((ServerLevel)targetEntity.level(), nextEntity.damageSources().mobAttack((LivingEntity)nextEntity), (float)finalDamageAmount);
                            TurnBasedMinecraftMod.proxy.setAttackingEntity(null);
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ATTACK, nextEntity.getId(), targetEntity.getId(), finalDamageAmount);
                            if (!attackEffectTriggered) continue;
                            nextEntityInfo.attackEffect.applyEffectToEntity((LivingEntity)targetEntity);
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.WAS_AFFECTED, nextEntity.getId(), targetEntity.getId(), 0, nextEntityInfo.attackEffect.getAffectedString());
                        }
                        ((Creeper)nextEntity).setSwellDir(1000000);
                        next.setWillCreeperExplode(true);
                    }
                }
lbl493:
                // 31 sources

                this.debugLog = "Action almost end";
                if (this.turnOrderQueue.isEmpty()) {
                    this.setDecisionState();
                    if (this.healthCheck()) {
                        combatantsChanged = true;
                    }
                    if (this.isCreativeCheck()) {
                        combatantsChanged = true;
                    }
                    this.debugLog = this.debugLog + ", adding task";
                    this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.TURN_END, 0, 0, 0);
                }
                this.debugLog = "Actions end";
                break;
            }
            default: {
                this.state = State.DECISION;
            }
        }
        this.debugLog = "Update almost end";
        if (combatantsChanged) {
            this.notifyPlayersBattleInfo();
        }
        if (this.battleEnded) {
            combatants = new ArrayList<Combatant>();
            combatants.addAll(this.sideA.values());
            combatants.addAll(this.sideB.values());
            for (Combatant c : combatants) {
                this.removeCombatant(c);
            }
        }
        this.debugLog = "Update end";
        return this.battleEnded;
    }

    private void defuseCreepers() {
        for (Combatant c : this.sideA.values()) {
            if (!(c.entity instanceof Creeper)) continue;
            if (c.willCreeperExplode) {
                ((Creeper)c.entity).setSwellDir(1000000);
                continue;
            }
            ((Creeper)c.entity).setSwellDir(-10);
        }
        for (Combatant c : this.sideB.values()) {
            if (!(c.entity instanceof Creeper)) continue;
            if (c.willCreeperExplode) {
                ((Creeper)c.entity).setSwellDir(1000000);
                continue;
            }
            ((Creeper)c.entity).setSwellDir(-10);
        }
    }

    public static enum State {
        DECISION(0),
        ACTION(1),
        DECISION_PLAYER_READY(2);

        private int value;
        private static Map<Integer, State> map;

        private State(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static State valueOf(int stateType) {
            return map.get(stateType);
        }

        static {
            map = new HashMap<Integer, State>();
            for (State state : State.values()) {
                map.put(state.value, state);
            }
        }
    }

    public static enum Decision {
        UNDECIDED(0),
        ATTACK(1),
        DEFEND(2),
        FLEE(3),
        USE_ITEM(4),
        SWITCH_ITEM(5),
        CREEPER_WAIT(6),
        CREEPER_EXPLODE(7);

        private int value;
        private static Map<Integer, Decision> map;

        private Decision(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Decision valueOf(int decisionType) {
            return map.get(decisionType);
        }

        static {
            map = new HashMap<Integer, Decision>();
            for (Decision decision : Decision.values()) {
                map.put(decision.value, decision);
            }
        }
    }
}

